/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.model.User;
import hudson.plugins.claim.AbstractClaimBuildAction;
import hudson.plugins.claim.Messages;
import java.util.Collections;
import java.util.Date;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public final class CommonMessagesProvider {
    private static final int DATA_PRESENT = 1;
    private static final int DATA_ABSENT = 0;
    private static final String NO_DATA = "";
    private static final String TERMINATOR = "";
    private final boolean claimed;
    private final String claimedBy;
    private final String assignedBy;
    private final Date date;
    private final Supplier<Formatter> objectFormatSupplier;
    private final Supplier<Formatter> formatSupplier;

    @Nonnull
    static CommonMessagesProvider build(@Nonnull AbstractClaimBuildAction action) {
        return CommonMessagesProvider.build(action.isClaimed(), action.getClaimedBy(), action.getAssignedBy(), action.getClaimDate());
    }

    @Nonnull
    private static CommonMessagesProvider build(boolean claimed, String claimedBy, String assignedBy, Date date) {
        return new CommonMessagesProvider(claimed, claimedBy, assignedBy, date);
    }

    private CommonMessagesProvider(boolean claimed, String claimedBy, String assignedBy, Date date) {
        this.claimed = claimed;
        this.claimedBy = claimedBy;
        this.assignedBy = assignedBy;
        this.date = date;
        this.formatSupplier = () -> this.getFormat(new MessagesProvider(){

            @Override
            public Formatter notClaimed() {
                return Messages::CommonMessages_NoObject_Unclaim;
            }

            @Override
            public Formatter claimedBySelf() {
                return Messages::CommonMessages_NoObject_Claim_Self;
            }

            @Override
            public Formatter assignedBySelf() {
                return Messages::CommonMessages_NoObject_Assign_Self;
            }

            @Override
            public Formatter assignedToSelf() {
                return Messages::CommonMessages_NoObject_Assign_ToSelf;
            }

            @Override
            public Formatter claimedByOther() {
                return Messages::CommonMessages_NoObject_Claim_Other;
            }

            @Override
            public Formatter assignedByAndToOther() {
                return Messages::CommonMessages_NoObject_Assign_Other;
            }
        });
        this.objectFormatSupplier = () -> this.getFormat(new MessagesProvider(){

            @Override
            public Formatter notClaimed() {
                return Messages::CommonMessages_Object_Unclaim;
            }

            @Override
            public Formatter claimedBySelf() {
                return Messages::CommonMessages_Object_Claim_Self;
            }

            @Override
            public Formatter assignedBySelf() {
                return Messages::CommonMessages_Object_Assign_Self;
            }

            @Override
            public Formatter assignedToSelf() {
                return Messages::CommonMessages_Object_Assign_ToSelf;
            }

            @Override
            public Formatter claimedByOther() {
                return Messages::CommonMessages_Object_Claim_Other;
            }

            @Override
            public Formatter assignedByAndToOther() {
                return Messages::CommonMessages_Object_Assign_Other;
            }
        });
    }

    private Formatter getFormat(MessagesProvider messagesProvider) {
        if (!this.claimed) {
            return messagesProvider.notClaimed();
        }
        Authentication auth = Jenkins.getAuthentication();
        String currentUser = auth.getName();
        boolean isAutoAssigned = this.claimedBy.equals(this.assignedBy);
        if (!currentUser.equals("anonymous")) {
            if (currentUser.equals(this.assignedBy)) {
                if (isAutoAssigned) {
                    return messagesProvider.claimedBySelf();
                }
                return messagesProvider.assignedBySelf();
            }
            if (currentUser.equals(this.claimedBy)) {
                return messagesProvider.assignedToSelf();
            }
        }
        if (isAutoAssigned) {
            return messagesProvider.claimedByOther();
        }
        return messagesProvider.assignedByAndToOther();
    }

    public String getFullClaimDescription(String objectName) {
        return CommonMessagesProvider.formatClaimDescription(this.objectFormatSupplier.get(), objectName, this.assignedBy, this.claimedBy, CommonMessagesProvider.isDataPresent(this.date), this.date, true);
    }

    public String getFullClaimDescription() {
        return CommonMessagesProvider.formatClaimDescription(this.formatSupplier.get(), "", this.assignedBy, this.claimedBy, CommonMessagesProvider.isDataPresent(this.date), this.date, true);
    }

    public String getShortClaimDescription(String objectName) {
        return CommonMessagesProvider.formatClaimDescription(this.objectFormatSupplier.get(), objectName, this.assignedBy, this.claimedBy, 0, this.date, false);
    }

    public String getShortClaimDescription() {
        return CommonMessagesProvider.formatClaimDescription(this.formatSupplier.get(), "", this.assignedBy, this.claimedBy, 0, this.date, false);
    }

    public String getReasonTitle() {
        return Messages.CommonMessages_Reason();
    }

    private static String formatClaimDescription(Formatter formatter, String objectName, String assignedBy, String claimedBy, int hasDate, Date date, boolean enhanceUserLinks) {
        return formatter.format(objectName, CommonMessagesProvider.getUserInfo(assignedBy, enhanceUserLinks), CommonMessagesProvider.getUserInfo(claimedBy, enhanceUserLinks), hasDate, date, "");
    }

    private static String getUserInfo(String userName, boolean enhanceUserLinks) {
        User user = User.get((String)userName, (boolean)false, Collections.emptyMap());
        String displayName = "anonymous";
        if (user != null && StringUtils.isEmpty((String)(displayName = user.getDisplayName()))) {
            displayName = userName;
        }
        if (enhanceUserLinks && user != null) {
            return "<a href=\"" + user.getAbsoluteUrl() + "\">" + displayName + "</a>";
        }
        return displayName;
    }

    private static int isDataPresent(Date data) {
        if (data == null) {
            return 0;
        }
        return 1;
    }

    @FunctionalInterface
    private static interface Formatter {
        public String format(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6);
    }

    private static interface MessagesProvider {
        public Formatter notClaimed();

        public Formatter claimedBySelf();

        public Formatter assignedBySelf();

        public Formatter assignedToSelf();

        public Formatter claimedByOther();

        public Formatter assignedByAndToOther();
    }
}

