/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.claim.ClaimEmailer;
import hudson.plugins.claim.ClaimTestAction;
import hudson.plugins.claim.Messages;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;
import org.kohsuke.stapler.DataBoundConstructor;

public class ClaimTestDataPublisher
extends TestDataPublisher {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");

    @DataBoundConstructor
    public ClaimTestDataPublisher() {
    }

    public Data contributeTestData(Run<?, ?> run, @Nonnull FilePath workspace, Launcher launcher, TaskListener listener, TestResult testResult) throws IOException, InterruptedException {
        Data data = new Data(run);
        HashMap<String, List<CaseResult>> claimedFailuresByUser = new HashMap<String, List<CaseResult>>();
        for (CaseResult result : testResult.getFailedTests()) {
            ClaimTestAction previousAction;
            CaseResult previous = result.getPreviousResult();
            if (previous == null || (previousAction = (ClaimTestAction)((Object)previous.getTestAction(ClaimTestAction.class))) == null || !previousAction.isClaimed() || !previousAction.isSticky()) continue;
            ClaimTestAction action = new ClaimTestAction(data, result.getId());
            previousAction.copyTo(action);
            data.addClaim(result.getId(), action);
            this.putAsListElement(claimedFailuresByUser, action.getClaimedBy(), result);
        }
        this.sendEmailsForStickyFailuresIfPresent(run, testResult, claimedFailuresByUser);
        return data;
    }

    private <K, V> void putAsListElement(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
        }
        list.add(value);
        map.put(key, list);
    }

    private void sendEmailsForStickyFailuresIfPresent(Run run, TestResult testResult, Map<String, List<CaseResult>> claimedFailuresByUser) {
        try {
            for (Map.Entry<String, List<CaseResult>> entry : claimedFailuresByUser.entrySet()) {
                String url = Functions.joinPath((String[])new String[]{run.getUrl(), testResult.getParentAction().getUrlName()});
                ClaimEmailer.sendRepeatedTestClaimEmailIfConfigured(entry.getKey(), run.toString(), url, entry.getValue());
            }
        }
        catch (IOException | MessagingException e) {
            LOGGER.log(Level.WARNING, "Exception when sending test failure reminder email. Ignoring.", e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        @Nonnull
        public String getDisplayName() {
            return Messages.ClaimTestDataPublisher_DisplayName();
        }
    }

    public static final class Data
    extends TestResultAction.Data
    implements Saveable {
        private Map<String, ClaimTestAction> claims = new HashMap<String, ClaimTestAction>();
        private final Run<?, ?> build;

        public Data(Run<?, ?> build) {
            this.build = build;
        }

        public String getUrl() {
            return this.build.getUrl();
        }

        public Run<?, ?> getBuild() {
            return this.build;
        }

        public List<? extends TestAction> getTestAction(TestObject testObject) {
            CaseResult cr;
            String prefix = "junit";
            String id = testObject.getId();
            ClaimTestAction result = this.claims.get(id);
            if (result == null && id.startsWith("junit")) {
                result = this.claims.get(id.substring("junit".length()));
            }
            if (result != null) {
                return Collections.singletonList(result);
            }
            if (testObject instanceof CaseResult && !(cr = (CaseResult)testObject).isPassed() && !cr.isSkipped()) {
                return Collections.singletonList(new ClaimTestAction(this, id));
            }
            return Collections.emptyList();
        }

        public void save() throws IOException {
            this.build.save();
        }

        public void addClaim(String testObjectId, ClaimTestAction claim) {
            this.claims.put(testObjectId, claim);
        }
    }
}

