/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimEmailer;
import hudson.plugins.claim.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ClaimPublisher
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void initIcons() throws Exception {
        IconSet.icons.addIcon(new Icon("icon-claim-claim icon-sm", "plugin/claim/images/16x16/claim.png", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-claim-claim icon-md", "plugin/claim/images/24x24/claim.png", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-claim-claim icon-lg", "plugin/claim/images/32x32/claim.png", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-claim-claim icon-xlg", "plugin/claim/images/48x48/claim.png", "width: 48px; height: 48px;"));
    }

    @DataBoundConstructor
    public ClaimPublisher() {
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Result runResult = build.getResult();
        if (runResult != null && runResult.isWorseThan(Result.SUCCESS)) {
            ClaimPublisher.addClaimBuildAction(build);
        }
    }

    static void addClaimBuildAction(Run<?, ?> build) throws IOException {
        ClaimBuildAction c;
        ClaimBuildAction action = new ClaimBuildAction();
        build.addAction((Action)action);
        build.save();
        Run previousBuild = build.getPreviousBuild();
        if (previousBuild != null && (c = (ClaimBuildAction)previousBuild.getAction(ClaimBuildAction.class)) != null && c.isClaimed() && c.isSticky()) {
            c.copyTo(action);
            ClaimPublisher.sendEmailsForStickyFailure(build, c.getClaimedBy());
        }
    }

    private static void sendEmailsForStickyFailure(Run<?, ?> build, String claimedByUser) {
        try {
            ClaimEmailer.sendRepeatedBuildClaimEmailIfConfigured(claimedByUser, build.toString(), build.getUrl());
        }
        catch (IOException | MessagingException e) {
            LOGGER.log(Level.WARNING, "Exception when sending build failure reminder email. Ignoring.", e);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getHelpFile() {
            return "/plugin/claim/help.html";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ClaimPublisher_DisplayName();
        }

        public boolean isApplicable(Class jobType) {
            return true;
        }
    }
}

