/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.plugins.claim.ClaimConfig;
import hudson.plugins.claim.messages.InitialBuildClaimMessage;
import hudson.plugins.claim.messages.InitialTestClaimMessage;
import hudson.plugins.claim.messages.RepeatedBuildClaimMessage;
import hudson.plugins.claim.messages.RepeatedTestClaimMessage;
import hudson.tasks.Mailer;
import hudson.tasks.junit.CaseResult;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.mail.MessagingException;

public final class ClaimEmailer {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");
    private static final boolean MAILER_LOADED = ClaimEmailer.isMailerLoaded();

    private static boolean isMailerLoaded() {
        boolean ret = true;
        try {
            new Mailer.DescriptorImpl();
        }
        catch (Throwable e) {
            LOGGER.warning("Mailer plugin is not installed. Mailer plugin must be installed if you want to send emails");
            ret = false;
        }
        return ret;
    }

    private ClaimEmailer() {
    }

    public static void sendInitialBuildClaimEmailIfConfigured(String claimedByUser, String assignedByUser, String action, String reason, String url) throws MessagingException, IOException {
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmails() && MAILER_LOADED) {
            InitialBuildClaimMessage message = new InitialBuildClaimMessage(action, url, reason, claimedByUser, assignedByUser);
            message.send();
        }
    }

    public static void sendInitialTestClaimEmailIfConfigured(String claimedByUser, String assignedByUser, String action, String reason, String url) throws MessagingException, IOException {
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmails() && MAILER_LOADED) {
            InitialTestClaimMessage message = new InitialTestClaimMessage(action, url, reason, claimedByUser, assignedByUser);
            message.send();
        }
    }

    public static void sendRepeatedBuildClaimEmailIfConfigured(String claimedByUser, String action, String url) throws MessagingException, IOException {
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmailsForStickyFailures() && MAILER_LOADED) {
            RepeatedBuildClaimMessage message = new RepeatedBuildClaimMessage(action, url, claimedByUser);
            message.send();
        }
    }

    public static void sendRepeatedTestClaimEmailIfConfigured(String claimedByUser, String action, String url, List<CaseResult> failedTests) throws MessagingException, IOException {
        ClaimConfig config = ClaimConfig.get();
        if (config.getSendEmailsForStickyFailures() && MAILER_LOADED) {
            RepeatedTestClaimMessage message = new RepeatedTestClaimMessage(action, url, claimedByUser, failedTests);
            message.send();
        }
    }
}

