/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class ClaimConfig
extends GlobalConfiguration {
    private static final String GROOVY_SCRIPT_KEY = "hudson.plugins.claim.ClaimConfig.groovyTrigger";
    private boolean sendEmails;
    private boolean sendEmailsForStickyFailures;
    private boolean stickyByDefault = true;
    private boolean propagateToFollowingBuildsByDefault = false;
    private boolean sortUsersByFullName;
    @Deprecated
    private transient String groovyScript;
    @Nonnull
    private SecureGroovyScript groovyTrigger;
    private boolean blockAutoRefreshWhileClaiming;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="groovyTrigger is initialized in setGroovyTrigger")
    public ClaimConfig() {
        this.load();
        if (this.groovyTrigger == null) {
            this.setGroovyTrigger(new SecureGroovyScript("", true, null), false);
        }
    }

    @Nonnull
    public String getDisplayName() {
        return "Claim";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.sendEmails = formData.getBoolean("sendEmails");
        this.sendEmailsForStickyFailures = formData.getBoolean("sendEmailsForStickyFailures");
        this.stickyByDefault = formData.getBoolean("stickyByDefault");
        this.propagateToFollowingBuildsByDefault = formData.getBoolean("propagateToFollowingBuildsByDefault");
        this.sortUsersByFullName = formData.getBoolean("sortUsersByFullName");
        this.blockAutoRefreshWhileClaiming = formData.getBoolean("blockAutoRefreshWhileClaiming");
        this.setGroovyTrigger((SecureGroovyScript)req.bindJSON(SecureGroovyScript.class, formData.getJSONObject("groovyTrigger")));
        this.save();
        return super.configure(req, formData);
    }

    public boolean getSendEmails() {
        return this.sendEmails;
    }

    public void setSendEmails(boolean val) {
        this.sendEmails = val;
    }

    public boolean getSendEmailsForStickyFailures() {
        return this.sendEmailsForStickyFailures;
    }

    public void setSendEmailsForStickyFailures(boolean val) {
        this.sendEmailsForStickyFailures = val;
    }

    public boolean isStickyByDefault() {
        return this.stickyByDefault;
    }

    public void setStickyByDefault(boolean stickyByDefault) {
        this.stickyByDefault = stickyByDefault;
    }

    public boolean isPropagateToFollowingBuildsByDefault() {
        return this.propagateToFollowingBuildsByDefault;
    }

    public void setPropagateToFollowingBuildsByDefault(boolean propagateToFollowingBuildsByDefault) {
        this.propagateToFollowingBuildsByDefault = propagateToFollowingBuildsByDefault;
    }

    public boolean isSortUsersByFullName() {
        return this.sortUsersByFullName;
    }

    public void setSortUsersByFullName(boolean sortUsersByFullName) {
        this.sortUsersByFullName = sortUsersByFullName;
    }

    public boolean isBlockAutoRefreshWhileClaiming() {
        return this.blockAutoRefreshWhileClaiming;
    }

    public void setBlockAutoRefreshWhileClaiming(boolean blockAutoRefreshWhileClaiming) {
        this.blockAutoRefreshWhileClaiming = blockAutoRefreshWhileClaiming;
    }

    @Nonnull
    public SecureGroovyScript getGroovyTrigger() {
        return this.groovyTrigger;
    }

    void setGroovyTrigger(@Nonnull SecureGroovyScript groovyTrigger) {
        this.setGroovyTrigger(groovyTrigger, true);
    }

    private void setGroovyTrigger(@Nonnull SecureGroovyScript trigger, boolean withCurrentUser) {
        ApprovalContext approvalContext = ApprovalContext.create().withKey(GROOVY_SCRIPT_KEY);
        if (withCurrentUser) {
            approvalContext = approvalContext.withCurrentUser();
        }
        this.groovyTrigger = trigger.configuring(approvalContext);
    }

    public boolean hasGroovyTrigger() {
        return StringUtils.isNotEmpty((String)this.groovyTrigger.getScript());
    }

    public static ClaimConfig get() {
        return (ClaimConfig)((Object)GlobalConfiguration.all().get(ClaimConfig.class));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="during migration, field can be null")
    private Object readResolve() {
        if (this.groovyTrigger == null) {
            String script = this.groovyScript != null ? this.groovyScript : "";
            this.setGroovyTrigger(new SecureGroovyScript(script, true, null), false);
        }
        return this;
    }
}

