/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import com.google.common.collect.Lists;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.StatisticsLogger;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.Run;
import hudson.plugins.claim.ClaimIndication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public final class ClaimBuildFailureAnalyzer {
    public static final String DEFAULT_ERROR = "Default";
    private static final String MATCHING_FILE = "Claim";
    @Nonnull
    private final String error;

    public ClaimBuildFailureAnalyzer(@Nonnull String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public boolean isDefaultError() {
        return DEFAULT_ERROR.equals(this.error);
    }

    public static Collection<FailureCause> getFailureCauses() throws Exception {
        return ClaimBuildFailureAnalyzer.getPluginImpl().getKnowledgeBase().getCauses();
    }

    private static PluginImpl getPluginImpl() {
        return (PluginImpl)ExtensionList.lookupSingleton(PluginImpl.class);
    }

    public static boolean isBFAEnabled() {
        Plugin plugin = Jenkins.get().getPlugin("build-failure-analyzer");
        return plugin != null && plugin.getWrapper().isActive() && ClaimBuildFailureAnalyzer.getPluginImpl().isGlobalEnabled();
    }

    public static HashMap<String, String> getFillReasonMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        for (FailureCause cause : ClaimBuildFailureAnalyzer.getFailureCauses()) {
            map.put(cause.getName(), cause.getDescription());
        }
        return map;
    }

    public static LinkedList<String> getDropdownList() throws Exception {
        LinkedList<String> list = new LinkedList<String>();
        for (FailureCause cause : ClaimBuildFailureAnalyzer.getFailureCauses()) {
            list.add(cause.getName());
        }
        return list;
    }

    public void createFailAction(Run run) throws Exception {
        FoundFailureCause newClaimedFailureCause = null;
        LinkedList<ClaimIndication> indications = new LinkedList<ClaimIndication>();
        for (FailureCause cause : ClaimBuildFailureAnalyzer.getFailureCauses()) {
            if (!cause.getName().equals(this.error)) continue;
            indications.add(new ClaimIndication(run, "Null", MATCHING_FILE, "Null"));
            newClaimedFailureCause = new FoundFailureCause(cause, indications);
            break;
        }
        ClaimBuildFailureAnalyzer.getPluginImpl().save();
        List bfaActionList = run.getActions(FailureCauseBuildAction.class);
        FoundFailureCause existingClaimedFoundFailureCause = null;
        FailureCauseBuildAction bfaAction = (FailureCauseBuildAction)bfaActionList.get(0);
        List foundFailureCauses = bfaAction.getFoundFailureCauses();
        boolean hasFailureCauseFromBFA = false;
        for (FoundFailureCause cause : foundFailureCauses) {
            if (cause.getName().equals(newClaimedFailureCause.getName()) && ((FoundIndication)cause.getIndications().get(0)).getMatchingFile().equals("log")) {
                hasFailureCauseFromBFA = true;
            }
            if (!((FoundIndication)cause.getIndications().get(0)).getMatchingFile().equals(MATCHING_FILE)) continue;
            existingClaimedFoundFailureCause = cause;
            break;
        }
        if (existingClaimedFoundFailureCause != null) {
            foundFailureCauses.remove(existingClaimedFoundFailureCause);
        }
        if (!hasFailureCauseFromBFA) {
            foundFailureCauses.add(newClaimedFailureCause);
        }
        try {
            run.save();
            StatisticsLogger.getInstance().log(run, bfaAction.getFoundFailureCauses());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeFailAction(Run run) {
        List bfaActionList = run.getActions(FailureCauseBuildAction.class);
        if (!bfaActionList.isEmpty()) {
            FailureCauseBuildAction bfaAction = (FailureCauseBuildAction)bfaActionList.get(0);
            List foundFailureCauses = bfaAction.getFoundFailureCauses();
            ArrayList toRemove = Lists.newArrayList();
            for (FoundFailureCause cause : foundFailureCauses) {
                if (cause.getIndications().size() <= 0 || !((FoundIndication)cause.getIndications().get(0)).getMatchingFile().equals(MATCHING_FILE)) continue;
                toRemove.add(cause);
            }
            foundFailureCauses.removeAll(toRemove);
        }
    }
}

