/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import groovy.lang.Binding;
import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.plugins.claim.ClaimBuildFailureAnalyzer;
import hudson.plugins.claim.ClaimConfig;
import hudson.plugins.claim.CommonMessagesProvider;
import hudson.plugins.claim.DescribableTestAction;
import hudson.plugins.claim.http.PreventRefreshFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public abstract class AbstractClaimBuildAction<T extends Saveable>
extends DescribableTestAction
implements BuildBadgeAction,
ProminentProjectAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");
    private boolean claimed;
    private String claimedBy;
    private String assignedBy;
    private Date claimDate;
    private boolean transientClaim = !ClaimConfig.get().isStickyByDefault();
    @Deprecated
    private transient boolean reclaim;
    private ClaimBuildFailureAnalyzer bfaClaimer = null;
    private String reason;

    protected abstract T getOwner();

    AbstractClaimBuildAction() {
    }

    public final CommonMessagesProvider getMessageProvider() {
        return CommonMessagesProvider.build(this);
    }

    @Deprecated
    public final boolean isReclaim() {
        return this.isClaimed();
    }

    public final ClaimBuildFailureAnalyzer getBfaClaimer() {
        return this.bfaClaimer;
    }

    public final String getIconFileName() {
        return null;
    }

    public final String getUrlName() {
        return "claim";
    }

    abstract String getUrl();

    public final void doClaim(StaplerRequest req, StaplerResponse resp) throws Exception {
        String currentUserId;
        Authentication authentication = Hudson.getAuthentication();
        User currentUser = User.getById((String)authentication.getName(), (boolean)false);
        String claimedUser = currentUserId = currentUser.getId();
        String assignee = req.getSubmittedForm().getString("assignee");
        if (!StringUtils.isEmpty((String)assignee) && !claimedUser.equals(assignee)) {
            User resolvedAssignee = User.get((String)assignee, (boolean)false, Collections.emptyMap());
            if (resolvedAssignee == null) {
                LOGGER.log(Level.WARNING, "Invalid username specified for assignment: {0}", assignee);
                resp.forwardToPreviousPage(req);
                return;
            }
            claimedUser = assignee;
        }
        String reasonProvided = req.getSubmittedForm().getString("reason");
        if (ClaimBuildFailureAnalyzer.isBFAEnabled()) {
            String error = req.getSubmittedForm().getString("errors");
            this.bfaClaimer = new ClaimBuildFailureAnalyzer(error);
            if (this.getOwner() instanceof Run) {
                Run run = (Run)this.getOwner();
                if (!this.bfaClaimer.isDefaultError()) {
                    try {
                        this.bfaClaimer.createFailAction(run);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOGGER.log(Level.WARNING, "No FailureCauseBuildAction detected for this build");
                        resp.forwardToPreviousPage(req);
                        return;
                    }
                } else {
                    this.bfaClaimer.removeFailAction(run);
                }
            }
        }
        boolean sticky = req.getSubmittedForm().getBoolean("sticky");
        boolean propagated = req.getSubmittedForm().getBoolean("propagateToFollowingBuilds");
        if (StringUtils.isEmpty((String)reasonProvided)) {
            reasonProvided = null;
        }
        this.claim(claimedUser, reasonProvided, currentUserId, new Date(), sticky, propagated, true);
        this.getOwner().save();
        this.evalGroovyScript();
        resp.forwardToPreviousPage(req);
    }

    @Deprecated
    public final void claim(String claimedByUser, String providedReason, String assignedByUser, boolean isSticky) {
        this.claim(claimedByUser, providedReason, assignedByUser, new Date(), isSticky, ClaimConfig.get().isPropagateToFollowingBuildsByDefault(), false);
    }

    public final void claim(String claimedByUser, String providedReason, String assignedByUser, Date date, boolean isSticky, boolean isPropagated, boolean notify) {
        this.applyClaim(claimedByUser, providedReason, assignedByUser, date, isSticky, isPropagated);
        if (notify) {
            try {
                this.sendInitialClaimEmail(claimedByUser, providedReason, assignedByUser);
            }
            catch (IOException | MessagingException e) {
                LOGGER.log(Level.WARNING, "Exception encountered sending assignment email: " + e.getMessage());
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted when sending assignment email", e);
            }
        }
    }

    protected abstract void sendInitialClaimEmail(String var1, String var2, String var3) throws MessagingException, IOException, InterruptedException;

    protected void applyClaim(String claimedByUser, String providedReason, String assignedByUser, Date date, boolean isSticky, boolean isPropagated) {
        this.claimed = true;
        this.claimedBy = claimedByUser;
        this.reason = providedReason;
        this.transientClaim = !isSticky;
        this.claimDate = date;
        this.assignedBy = assignedByUser;
        if (isPropagated) {
            this.getNextAction().ifPresent(action -> {
                if (!action.isClaimed()) {
                    action.applyClaim(claimedByUser, providedReason, assignedByUser, date, isSticky, true);
                    try {
                        action.getOwner().save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected abstract Optional<AbstractClaimBuildAction> getNextAction();

    public final void doUnclaim(StaplerRequest req, StaplerResponse resp) throws ServletException, IOException {
        this.unclaim();
        if (ClaimBuildFailureAnalyzer.isBFAEnabled() && this.bfaClaimer != null) {
            this.bfaClaimer.removeFailAction((Run)this.getOwner());
        }
        this.getOwner().save();
        this.evalGroovyScript();
        resp.forwardToPreviousPage(req);
    }

    @Deprecated
    public final void unclaim() {
        this.unclaim(false);
    }

    public final void unclaim(boolean notify) {
        this.applyUnclaim();
    }

    protected void applyUnclaim() {
        this.claimed = false;
        this.claimedBy = null;
        this.transientClaim = false;
        this.claimDate = null;
        this.assignedBy = null;
    }

    @Exported
    public final String getClaimedBy() {
        return this.claimedBy;
    }

    @Exported
    public final String getAssignedBy() {
        return this.assignedBy;
    }

    public final String getClaimedByName() {
        User user = User.get((String)this.claimedBy, (boolean)false, Collections.emptyMap());
        if (user != null) {
            return user.getDisplayName();
        }
        return this.claimedBy;
    }

    public final String getAssignedByName() {
        User user = User.get((String)this.assignedBy, (boolean)false, Collections.emptyMap());
        if (user != null) {
            return user.getDisplayName();
        }
        return this.assignedBy;
    }

    public final void setClaimedBy(String claimedBy) {
        this.claimedBy = claimedBy;
    }

    public final void setAssignedBy(String assignedBy) {
        this.assignedBy = assignedBy;
    }

    @Exported
    public final boolean isClaimed() {
        return this.claimed;
    }

    protected void copyTo(AbstractClaimBuildAction<T> other) {
        other.applyClaim(this.getClaimedBy(), this.getReason(), this.getAssignedBy(), this.getClaimDate(), this.isSticky(), false);
    }

    public final boolean isClaimedByMe() {
        return !this.isUserAnonymous() && Hudson.getAuthentication().getName().equals(this.claimedBy);
    }

    public final boolean canReassign() {
        return !this.isUserAnonymous() && this.isClaimed();
    }

    public final boolean canClaim() {
        return !this.isUserAnonymous() && !this.isClaimedByMe();
    }

    public final boolean canRelease() {
        return !this.isUserAnonymous() && this.isClaimedByMe();
    }

    public final boolean isUserAnonymous() {
        return Hudson.getAuthentication().getName().equals("anonymous");
    }

    @Exported
    public final String getReason() {
        return this.reason;
    }

    @JavaScriptMethod
    public final String getReason(String error) throws Exception {
        String defaultValue = "";
        if (!ClaimBuildFailureAnalyzer.isBFAEnabled()) {
            return "";
        }
        if (error == null || "Default".equals(error)) {
            return "";
        }
        return ClaimBuildFailureAnalyzer.getFillReasonMap().getOrDefault(error, "");
    }

    @Restricted(value={DoNotUse.class})
    public final void preventRefresh(StaplerResponse response) {
        PreventRefreshFilter.preventRefresh(response);
    }

    public final void setReason(String reason) {
        this.reason = reason;
    }

    public final boolean hasReason() {
        return !StringUtils.isEmpty((String)this.reason);
    }

    public final boolean isTransientClaim() {
        return this.transientClaim;
    }

    public final void setTransientClaim(boolean transientClaim) {
        this.transientClaim = transientClaim;
    }

    public final boolean isSticky() {
        return !this.transientClaim;
    }

    public final void setSticky(boolean sticky) {
        this.transientClaim = !sticky;
    }

    @Restricted(value={DoNotUse.class})
    public final boolean isPropagateToFollowingBuildsByDefault() {
        return ClaimConfig.get().isPropagateToFollowingBuildsByDefault();
    }

    public final String getError() {
        if (this.bfaClaimer == null) {
            return null;
        }
        return this.bfaClaimer.getError();
    }

    public final boolean isBFAEnabled() {
        return ClaimBuildFailureAnalyzer.isBFAEnabled();
    }

    @Exported
    public final Date getClaimDate() {
        if (this.claimDate == null) {
            return null;
        }
        return (Date)this.claimDate.clone();
    }

    public final boolean hasClaimDate() {
        return this.claimDate != null;
    }

    public boolean isSelfAssigned() {
        boolean ret = true;
        if (!this.isClaimed()) {
            ret = false;
        } else if (this.getClaimedBy() == null) {
            ret = false;
        } else if (!this.getClaimedBy().equals(this.getAssignedBy())) {
            ret = false;
        }
        return ret;
    }

    public abstract String getNoun();

    protected final void evalGroovyScript() {
        ClaimConfig config = ClaimConfig.get();
        if (config.hasGroovyTrigger()) {
            SecureGroovyScript groovyScript = config.getGroovyTrigger();
            Binding binding = new Binding();
            binding.setVariable("action", (Object)this);
            try {
                groovyScript.evaluate(Jenkins.getInstance().getPluginManager().uberClassLoader, binding);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error evaluating Groovy script", e);
            }
        }
    }
}

