/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.View;
import hudson.plugins.claim.AbstractClaimBuildAction;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimTestAction;
import hudson.plugins.claim.ClaimUtils;
import hudson.plugins.claim.CommonMessagesProvider;
import hudson.plugins.claim.Messages;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.Stapler;

public class AbstractAssignedClaimsReport
implements Action,
IconSpec {
    public String getIconClassName() {
        return "icon-claim-claim";
    }

    public String getIconFileName() {
        Icon icon;
        String iconClassName = this.getIconClassName();
        if (iconClassName != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " icon-md"))) != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    public String getUrlName() {
        return "/claims";
    }

    @Restricted(value={DoNotUse.class})
    public Run getFirstFail(Run r) {
        Run lastGood = r.getPreviousNotFailedBuild();
        Run firstFail = lastGood == null ? r.getParent().getFirstBuild() : lastGood.getNextBuild();
        return firstFail;
    }

    @Restricted(value={DoNotUse.class})
    public CommonMessagesProvider getMessageProvider(Run r) {
        return CommonMessagesProvider.build(this.getAction(r));
    }

    @Restricted(value={DoNotUse.class})
    public CommonMessagesProvider getMessageProvider(TestResult tr) {
        return CommonMessagesProvider.build((AbstractClaimBuildAction)((Object)tr.getTestAction(ClaimTestAction.class)));
    }

    public ModelObject getOwner() {
        View view = (View)Stapler.getCurrentRequest().findAncestorObject(View.class);
        if (view != null) {
            return view;
        }
        return Jenkins.getInstance().getStaplerFallback();
    }

    private ClaimBuildAction getAction(Run r) {
        return ClaimUtils.getBuildAction(r, false);
    }

    public RunList getBuilds() {
        ArrayList<Run> lastBuilds = new ArrayList<Run>();
        for (Job job : this.getJobs()) {
            Run lb = job.getLastCompletedBuild();
            if (lb == null || !this.isDisplayed((AbstractClaimBuildAction)lb.getAction(ClaimBuildAction.class))) continue;
            lastBuilds.add(lb);
        }
        return RunList.fromRuns(lastBuilds).failureOnly();
    }

    protected List<Job> getJobs() {
        return Jenkins.getInstance().getAllItems(Job.class);
    }

    public List<TestResult> getTestFailuresWithClaim() {
        ArrayList<TestResult> claimedTestFailures = new ArrayList<TestResult>();
        for (Job job : this.getJobs()) {
            AbstractTestResultAction testResultAction;
            Run lb = job.getLastCompletedBuild();
            if (lb == null || (testResultAction = (AbstractTestResultAction)lb.getAction(AbstractTestResultAction.class)) == null) continue;
            List failedTests = testResultAction.getFailedTests();
            for (TestResult failedTest : failedTests) {
                ClaimTestAction claimAction = (ClaimTestAction)((Object)failedTest.getTestAction(ClaimTestAction.class));
                if (!this.isDisplayed(claimAction)) continue;
                claimedTestFailures.add(failedTest);
            }
        }
        return claimedTestFailures;
    }

    protected boolean isDisplayed(AbstractClaimBuildAction<?> claimAction) {
        return claimAction != null && claimAction.isClaimed();
    }

    public String getDisplayName() {
        return Messages.ClaimedBuildsReport_DisplayName();
    }
}

