/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.MainConfiguration;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jenkins.model.GlobalConfiguration;

public class ProcessLauncher {
    public static int exec(Map<String, String> args, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String javaHome = env.get("JAVA_HOME", System.getProperty("java.home"));
        String javaBin = javaHome + "/bin/java";
        FilePath cliFolder = ProcessLauncher.getWorkspaceCliFolder(build);
        FilePath osgiDir = ProcessLauncher.getOsgiDir(build);
        String exec = null;
        try {
            exec = cliFolder + "/" + ProcessLauncher.getCliJarName(build);
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
        }
        ArgumentListBuilder arguments = new ArgumentListBuilder();
        arguments.add(javaBin);
        arguments.add("-jar");
        arguments.add(exec);
        arguments.add("-lib");
        arguments.add(cliFolder + "/lib");
        arguments.add("-workspace");
        arguments.add(osgiDir.toURI().getPath());
        for (Map.Entry<String, String> e : args.entrySet()) {
            arguments.add(e.getKey());
            arguments.add(e.getValue());
        }
        if (!launcher.isUnix()) {
            arguments = arguments.toWindowsCommand();
        }
        Launcher.ProcStarter procStarter = launcher.launch();
        int result = procStarter.stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger()).cmds(arguments).pwd(build.getModuleRoot()).join();
        cliFolder.deleteRecursive();
        return result;
    }

    private static String getCliJarName(AbstractBuild<?, ?> build) throws Exception {
        List list = new FilePath(build.getWorkspace(), "cli-dir").list();
        for (FilePath item : list) {
            if (!item.getName().endsWith(".jar")) continue;
            return item.getName();
        }
        throw new Exception("Configured folder doesn't contain CLI tools");
    }

    private static FilePath getOsgiDir(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath dir = new FilePath(build.getWorkspace(), "workspace");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static FilePath getWorkspaceCliFolder(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        MainConfiguration config = (MainConfiguration)((Object)GlobalConfiguration.all().get(MainConfiguration.class));
        if (config == null) {
            throw new RuntimeException("MainConfiguration extension is not available.");
        }
        if (config.getLibs() == null) {
            throw new RuntimeException("Path to libraries folder is undefined.");
        }
        FilePath zippedLibs = new FilePath(new File(config.getLibs()));
        FilePath target = new FilePath(build.getWorkspace(), "cli-dir");
        zippedLibs.unzip(target);
        return target;
    }
}

