/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.DatabaseSystem;
import ci.with.toad.edge.FileUtils;
import ci.with.toad.edge.FormValidationUtil;
import ci.with.toad.edge.MainConfiguration;
import ci.with.toad.edge.ProcessLauncher;
import ci.with.toad.edge.ReportFrameAction;
import ci.with.toad.edge.ReportPublisherAction;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GenerateJenkinsReportBuilder
extends Builder {
    private String OUTPUT = "JENKINS_REPORT";
    private String INPUT = "TMP_INPUT";
    private String inputFolder;

    @DataBoundConstructor
    public GenerateJenkinsReportBuilder(String inputFolder) {
        this.inputFolder = inputFolder;
    }

    public String getInputFolder() {
        return this.inputFolder;
    }

    protected File getCompareReportsDir(Run<?, ?> build) {
        return new File(build.getRootDir(), this.OUTPUT);
    }

    private FilePath getTmpIn(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), this.INPUT + build.number);
    }

    private FilePath getTmpOut(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), this.OUTPUT + build.number);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        System.setOut(listener.getLogger());
        System.setErr(listener.getLogger());
        this.copyBuildFiles(build, listener);
        FilePath tmpOutput = this.getTmpOut(build);
        tmpOutput.mkdirs();
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("-out", tmpOutput.toURI().getPath());
        arguments.put("-in", this.getTmpIn(build).toURI().getPath());
        arguments.put("-report", "");
        arguments.put("-type", "JENKINS");
        boolean result = ProcessLauncher.exec(arguments, build, launcher, listener) == 0;
        this.copyReportToTargetLocation(build, listener);
        this.deleteBuildFiles(build, listener);
        ReportPublisherAction action = new ReportPublisherAction(this.getCompareReportsDir((Run<?, ?>)build));
        ReportFrameAction frameAction = new ReportFrameAction(this.getCompareReportsDir((Run<?, ?>)build));
        build.addAction((Action)action);
        build.addAction((Action)frameAction);
        return result;
    }

    private void copyReportToTargetLocation(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath jobOutputDir = this.getTmpOut(build);
        File compareReportsDir = this.getCompareReportsDir((Run<?, ?>)build);
        try {
            compareReportsDir.mkdirs();
        }
        catch (SecurityException e) {
            throw new RuntimeException("Unable to create " + compareReportsDir.getPath());
        }
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{jobOutputDir, compareReportsDir}).toString());
        jobOutputDir.copyRecursiveTo(new FilePath(compareReportsDir));
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void copyBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath compareOutputDir = FileUtils.getFilePath(build, this.inputFolder);
        FilePath workspaceInput = this.getTmpIn(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{compareOutputDir, workspaceInput}).toString());
        compareOutputDir.copyRecursiveTo(workspaceInput);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void deleteBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspaceInputDir = this.getTmpIn(build);
        FilePath workspaceOutputDir = this.getTmpOut(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{workspaceInputDir}).toString());
        workspaceInputDir.deleteRecursive();
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{workspaceOutputDir}).toString());
        workspaceOutputDir.deleteRecursive();
    }

    public GenerateReportBuilderDescriptor getDescriptor() {
        return (GenerateReportBuilderDescriptor)super.getDescriptor();
    }

    @Extension
    public static class GenerateReportBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public GenerateReportBuilderDescriptor() {
            this.load();
        }

        public ListBoxModel doFillDatabaseSystemItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseSystem s : DatabaseSystem.values()) {
                items.add(s.getDisplayName(), s.name());
            }
            return items;
        }

        public FormValidation doCheckInputFolder(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "InputFolderLocation", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "GenerateJenkinsReport", new Object[0]).toString();
        }
    }
}

