/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.DatabaseSystem;
import ci.with.toad.edge.FileUtils;
import ci.with.toad.edge.FormValidationUtil;
import ci.with.toad.edge.MainConfiguration;
import ci.with.toad.edge.ProcessLauncher;
import com.google.common.io.Files;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CreateBaselineBuilder
extends Builder {
    private String outputFile;
    private String inputFileOrFolder;
    private static final String INPUT = "INPUT";
    private static final String TMP_OUTPUT = "TMP_OUTPUT";

    @DataBoundConstructor
    public CreateBaselineBuilder(String outputFile, String inputFileOrFolder) {
        this.outputFile = outputFile;
        this.inputFileOrFolder = inputFileOrFolder;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getInputFileOrFolder() {
        return this.inputFileOrFolder;
    }

    private FilePath getTmpInput(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath input = FileUtils.getFilePath(build, this.inputFileOrFolder);
        if (input.isDirectory()) {
            return new FilePath(build.getWorkspace(), INPUT + build.number);
        }
        return new FilePath(build.getWorkspace(), INPUT + build.number + "." + Files.getFileExtension((String)input.getName()));
    }

    private FilePath getTmpOutput(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        return new FilePath(build.getWorkspace(), TMP_OUTPUT + build.number);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        System.setOut(listener.getLogger());
        System.setErr(listener.getLogger());
        this.copyBuildFiles(build, listener);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("-in", this.getTmpInput(build).toURI().getPath());
        arguments.put("-out", this.getTmpOutput(build).toURI().getPath());
        arguments.put("-baseline", "");
        boolean result = ProcessLauncher.exec(arguments, build, launcher, listener) == 0;
        this.copySnapshotToTargetLocation(build, listener);
        this.deleteBuildFiles(build, listener);
        return result;
    }

    private void copyBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath input = FileUtils.getFilePath(build, this.inputFileOrFolder);
        if (input.isDirectory()) {
            FilePath workspaceInput = this.getTmpInput(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{input, workspaceInput}).toString());
            input.copyRecursiveTo(workspaceInput);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        } else {
            FilePath workspaceInput = this.getTmpInput(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{input, workspaceInput}).toString());
            input.copyTo(workspaceInput);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        }
    }

    private void copySnapshotToTargetLocation(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath tmpOutput = this.getTmpOutput(build);
        FilePath snapshotFile = FileUtils.getFilePath(build, this.outputFile);
        if (snapshotFile.getParent() != null) {
            snapshotFile.getParent().mkdirs();
        }
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{tmpOutput, snapshotFile}).toString());
        tmpOutput.copyTo(snapshotFile);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void deleteBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath jobInput = this.getTmpInput(build);
        if (jobInput.isDirectory()) {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{jobInput}).toString());
            jobInput.deleteRecursive();
        } else {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{jobInput}).toString());
            jobInput.delete();
        }
        FilePath output = this.getTmpOutput(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{output}).toString());
        output.delete();
    }

    public ToadBuilderDescriptor getDescriptor() {
        return (ToadBuilderDescriptor)super.getDescriptor();
    }

    @Extension
    public static class ToadBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public ToadBuilderDescriptor() {
            this.load();
        }

        public ListBoxModel doFillDatabaseSystemItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseSystem s : DatabaseSystem.values()) {
                items.add(s.getDisplayName(), s.name());
            }
            return items;
        }

        public FormValidation doCheckOutputFile(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "OutputFile", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInputFileOrFolder(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "InputFileOrFolderLocation", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "TakeBaseline", new Object[0]).toString();
        }
    }
}

