/*
 * Decompiled with CFR 0.152.
 */
package io.chef.jenkins;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import io.chef.jenkins.Messages;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ChefIdentityCleanup
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(ChefIdentityCleanup.class.getName());
    private ExecuteOn executeOn;

    @DataBoundConstructor
    public ChefIdentityCleanup(ExecuteOn executeOn) {
        this.executeOn = executeOn;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractProject job = build.getProject();
        boolean axis = ChefIdentityCleanup.isMatrixAxe((Job)job);
        if (axis && this.executeOn.axes()) {
            return this._perform(build, launcher, listener);
        }
        return axis || this._perform(build, launcher, listener);
    }

    public boolean _perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.cleanup(build.getWorkspace(), (TaskListener)listener);
    }

    private boolean cleanup(FilePath workspace, TaskListener listener) throws AbortException {
        listener.getLogger().append("\nChef Identity cleanup happening... \n");
        try {
            if (workspace == null || !workspace.exists()) {
                return true;
            }
            new FilePath(workspace, ".chef").deleteRecursive();
            listener.getLogger().append(".chef folder removed\n");
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            listener.getLogger().append("Cannot delete .chef folder: " + ex.getMessage() + "\n");
            throw new AbortException("Cannot delete .chef folder: " + ex.getMessage());
        }
        return true;
    }

    public MatrixAggregator createAggregator(final MatrixBuild matrixBuild, Launcher launcher, final BuildListener buildListener) {
        return new MatrixAggregator(matrixBuild, launcher, buildListener){

            public boolean endBuild() throws InterruptedException, IOException {
                return !ChefIdentityCleanup.this.executeOn.matrix() || ChefIdentityCleanup.this._perform((AbstractBuild<?, ?>)matrixBuild, this.launcher, buildListener);
            }
        };
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    private static boolean isMatrixAxe(Job job) {
        return job instanceof MatrixConfiguration;
    }

    public static final class WrapperDisposerImpl
    extends SimpleBuildWrapper.Disposer {
        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            ChefIdentityCleanup cleanup = new ChefIdentityCleanup(null);
            cleanup.cleanup(workspace, listener);
        }
    }

    public static enum ExecuteOn {
        MATRIX,
        AXES,
        BOTH;


        public boolean matrix() {
            return this == MATRIX || this == BOTH;
        }

        public boolean axes() {
            return this == AXES || this == BOTH;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(ChefIdentityCleanup.class);
        }

        public String getDisplayName() {
            return Messages.ChefIdentityCleanup_delete_chef_folder();
        }

        public boolean isApplicable(Class clazz) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

