/*
 * Decompiled with CFR 0.152.
 */
package io.chef.jenkins;

import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChefIdentity
implements Serializable {
    private static final Logger log = Logger.getLogger(ChefIdentity.class.getName());
    private final String idName;
    private Secret pemKey;
    private Secret knifeRb;
    private final boolean convertedSecret;

    public ChefIdentity() {
        this.idName = null;
        this.pemKey = null;
        this.knifeRb = null;
        this.convertedSecret = false;
    }

    @DataBoundConstructor
    public ChefIdentity(String idName, String pemKey, String knifeRb) {
        this.idName = idName;
        if (this.pemKey == null) {
            this.pemKey = Secret.fromString((String)pemKey);
        }
        if (this.knifeRb == null) {
            this.knifeRb = Secret.fromString((String)knifeRb);
        }
        this.convertedSecret = true;
    }

    public String getIdName() {
        return this.idName;
    }

    public String getPemKey() {
        if (this.convertedSecret) {
            return Secret.toString((Secret)this.pemKey);
        }
        return Scrambler.descramble((String)this.pemKey.getPlainText());
    }

    public String getKnifeRb() {
        if (this.convertedSecret) {
            return Secret.toString((Secret)this.knifeRb);
        }
        return Scrambler.descramble((String)this.knifeRb.getPlainText());
    }
}

