/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.CommonUtils;
import org.jenkinsci.plugins.cas.CasSecurityRealm;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;

public class SessionUrlCasAuthenticationEntryPoint
extends CasAuthenticationEntryPoint {
    private String targetUrlParameter;
    private String targetUrlSessionAttribute;

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl;
        if (this.targetUrlParameter != null && this.targetUrlSessionAttribute != null && (targetUrl = request.getParameter(this.targetUrlParameter)) != null) {
            HttpSession session = request.getSession(true);
            session.setAttribute(this.targetUrlSessionAttribute, (Object)targetUrl);
        }
    }

    protected String createServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        String serviceUrl = CasSecurityRealm.getServiceUrl(request, this.getServiceProperties());
        return CommonUtils.constructServiceUrl(null, (HttpServletResponse)response, (String)serviceUrl, null, (String)this.getServiceProperties().getServiceParameter(), (String)this.getServiceProperties().getArtifactParameter(), (boolean)this.getEncodeServiceUrlWithSessionId());
    }

    public String getTargetUrlParameter() {
        return this.targetUrlParameter;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        this.targetUrlParameter = targetUrlParameter;
    }

    public String getTargetUrlSessionAttribute() {
        return this.targetUrlSessionAttribute;
    }

    public void setTargetUrlSessionAttribute(String targetUrlSessionAttribute) {
        this.targetUrlSessionAttribute = targetUrlSessionAttribute;
    }
}

