/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import hudson.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.util.StringUtils;

public class SessionUrlAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    public static final String DEFAULT_TARGET_URL_SESSION_ATTRIBUTE = "spring-security-redirect";
    private String targetUrlSessionAttribute = "spring-security-redirect";

    public SessionUrlAuthenticationSuccessHandler(String defaultTargetUrl) {
        super(defaultTargetUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl = null;
        HttpSession session = request.getSession(false);
        if (session != null && this.targetUrlSessionAttribute != null) {
            targetUrl = (String)session.getAttribute(this.targetUrlSessionAttribute);
            session.removeAttribute(this.targetUrlSessionAttribute);
        }
        if (this.isAlwaysUseDefaultTargetUrl() || !StringUtils.hasText(targetUrl) || this.getTargetUrlParameter() != null && StringUtils.hasText((String)request.getParameter(this.getTargetUrlParameter()))) {
            targetUrl = super.determineTargetUrl(request, response);
        } else {
            this.logger.debug((Object)("Found targetUrlSessionAttribute in request: " + targetUrl));
        }
        if (targetUrl.startsWith(request.getContextPath())) {
            targetUrl = targetUrl.substring(request.getContextPath().length());
        }
        if (!Util.isSafeToRedirectTo((String)targetUrl)) {
            this.logger.debug((Object)("Target URL is not safe to redirect to and will be ignored: " + targetUrl));
            targetUrl = this.getDefaultTargetUrl();
        }
        return targetUrl;
    }

    public String getTargetUrlSessionAttribute() {
        return this.targetUrlSessionAttribute;
    }

    public void setTargetUrlSessionAttribute(String targetUrlSessionAttribute) {
        this.targetUrlSessionAttribute = targetUrlSessionAttribute;
    }
}

