/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import javax.servlet.http.HttpSession;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;

public class CasSessionFixationProtectionStrategy
extends SessionFixationProtectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CasSessionFixationProtectionStrategy.class);
    protected SessionMappingStorage sessionStorage = null;

    public CasSessionFixationProtectionStrategy() {
    }

    public CasSessionFixationProtectionStrategy(SessionMappingStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    protected void onSessionChange(String originalSessionId, HttpSession newSession, Authentication auth) {
        if (this.sessionStorage != null) {
            LOG.debug("Session changed, removing existing session with ID '{}'", (Object)originalSessionId);
            this.sessionStorage.removeBySessionById(originalSessionId);
            if (auth.getCredentials() instanceof String) {
                LOG.debug("Session changed, adding new session with ID '{}'", (Object)newSession.getId());
                this.sessionStorage.addSessionById((String)auth.getCredentials(), newSession);
            }
        }
        super.onSessionChange(originalSessionId, newSession, auth);
    }

    public SessionMappingStorage getSessionStorage() {
        return this.sessionStorage;
    }

    public void setSessionStorage(SessionMappingStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }
}

