/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring;

import hudson.security.ChainedServletFilter;
import hudson.security.HttpSessionContextIntegrationFilter2;
import hudson.security.SecurityRealm;
import java.util.Collections;
import javax.servlet.Filter;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutHandler;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.jenkinsci.plugins.cas.CasProtocol;
import org.jenkinsci.plugins.cas.CasSecurityRealm;
import org.jenkinsci.plugins.cas.spring.CasEventListener;
import org.jenkinsci.plugins.cas.spring.security.CasRestAuthenticator;
import org.jenkinsci.plugins.cas.spring.security.CasSessionFixationProtectionStrategy;
import org.jenkinsci.plugins.cas.spring.security.CasSingleSignOutFilter;
import org.jenkinsci.plugins.cas.spring.security.CasUserDetailsService;
import org.jenkinsci.plugins.cas.spring.security.DynamicServiceAuthenticationDetailsSource;
import org.jenkinsci.plugins.cas.spring.security.SessionUrlAuthenticationSuccessHandler;
import org.jenkinsci.plugins.cas.spring.security.SessionUrlCasAuthenticationEntryPoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

@Configuration(proxyBeanMethods=false)
public class CasConfigurationContext {
    @Bean
    public AuthenticationEventPublisher authenticationEventPublisher() {
        return new DefaultAuthenticationEventPublisher();
    }

    @Bean
    public CasEventListener casEventListener(CasProtocol casProtocol) {
        CasEventListener casEventListener = new CasEventListener();
        casEventListener.setFullNameAttribute(casProtocol.getFullNameAttribute());
        casEventListener.setEmailAttribute(casProtocol.getEmailAttribute());
        return casEventListener;
    }

    @Bean
    public ServiceProperties casServiceProperties(CasSecurityRealm securityRealm, CasProtocol casProtocol) {
        ServiceProperties casServiceProperties = casProtocol.createServiceProperties();
        casServiceProperties.setSendRenew(securityRealm.forceRenewal.booleanValue());
        casServiceProperties.setService(CasSecurityRealm.getFinishLoginUrl());
        return casServiceProperties;
    }

    @Bean
    public TicketValidator casTicketValidator(CasSecurityRealm securityRealm, CasProtocol casProtocol) {
        TicketValidator casTicketValidator = casProtocol.createTicketValidator(securityRealm.casServerUrl);
        if (casTicketValidator instanceof AbstractUrlBasedTicketValidator) {
            ((AbstractUrlBasedTicketValidator)casTicketValidator).setRenew(securityRealm.forceRenewal.booleanValue());
        }
        return casTicketValidator;
    }

    @Bean
    public CasUserDetailsService casUserDetailsService(CasProtocol casProtocol) {
        CasUserDetailsService casUserDetailsService = new CasUserDetailsService();
        casUserDetailsService.setAttributes(casProtocol.getAuthoritiesAttributes());
        casUserDetailsService.setConvertToUpperCase(false);
        casUserDetailsService.setDefaultAuthorities(Collections.singletonList(SecurityRealm.AUTHENTICATED_AUTHORITY2.getAuthority()));
        return casUserDetailsService;
    }

    @Bean
    public CasAuthenticationProvider casAuthenticationProvider(TicketValidator casTicketValidator, CasUserDetailsService casUserDetailsService) {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setTicketValidator(casTicketValidator);
        casAuthenticationProvider.setAuthenticationUserDetailsService((AuthenticationUserDetailsService)casUserDetailsService);
        casAuthenticationProvider.setKey("cas_auth_provider");
        return casAuthenticationProvider;
    }

    @Bean
    public AuthenticationManager casAuthenticationManager(CasAuthenticationProvider casAuthenticationProvider, AuthenticationEventPublisher authenticationEventPublisher) {
        ProviderManager casAuthenticationManager = new ProviderManager(new AuthenticationProvider[]{casAuthenticationProvider});
        casAuthenticationManager.setAuthenticationEventPublisher(authenticationEventPublisher);
        return casAuthenticationManager;
    }

    @Bean
    public CasAuthenticationEntryPoint casAuthenticationEntryPoint(CasSecurityRealm securityRealm, ServiceProperties casServiceProperties) {
        SessionUrlCasAuthenticationEntryPoint casAuthenticationEntryPoint = new SessionUrlCasAuthenticationEntryPoint();
        casAuthenticationEntryPoint.setLoginUrl(securityRealm.casServerUrl + "login");
        casAuthenticationEntryPoint.setServiceProperties(casServiceProperties);
        casAuthenticationEntryPoint.setTargetUrlParameter("from");
        casAuthenticationEntryPoint.setTargetUrlSessionAttribute("spring-security-redirect");
        return casAuthenticationEntryPoint;
    }

    @Bean
    public DynamicServiceAuthenticationDetailsSource casAuthenticationDetailsSource(ServiceProperties casServiceProperties) {
        return new DynamicServiceAuthenticationDetailsSource(casServiceProperties);
    }

    @Bean
    public SessionMappingStorage casSessionMappingStorage() {
        return new HashMapBackedSessionMappingStorage();
    }

    @Bean
    public HttpSessionContextIntegrationFilter2 httpSessionContextIntegrationFilter() {
        HttpSessionSecurityContextRepository httpSessionSecurityContextRepository = new HttpSessionSecurityContextRepository();
        httpSessionSecurityContextRepository.setAllowSessionCreation(false);
        return new HttpSessionContextIntegrationFilter2((SecurityContextRepository)httpSessionSecurityContextRepository);
    }

    @Bean
    public SingleSignOutHandler casSingleSignOutHandler(CasProtocol casProtocol, SessionMappingStorage casSessionMappingStorage) {
        SingleSignOutHandler casSingleSignOutHandler = new SingleSignOutHandler();
        casSingleSignOutHandler.setArtifactParameterName(casProtocol.getArtifactParameter());
        casSingleSignOutHandler.setSessionMappingStorage(casSessionMappingStorage);
        return casSingleSignOutHandler;
    }

    @Bean
    public CasSingleSignOutFilter casSingleSignOutFilter(CasSecurityRealm securityRealm, SingleSignOutHandler casSingleSignOutHandler) {
        CasSingleSignOutFilter casSingleSignOutFilter = new CasSingleSignOutFilter();
        casSingleSignOutFilter.setEnabled(securityRealm.enableSingleSignOut);
        casSingleSignOutFilter.setFilterProcessesUrl("/" + CasSecurityRealm.getFinishLoginUrl());
        casSingleSignOutFilter.setSingleSignOutHandler(casSingleSignOutHandler);
        return casSingleSignOutFilter;
    }

    @Bean
    public CasAuthenticationFilter casAuthenticationFilter(AuthenticationManager casAuthenticationManager, DynamicServiceAuthenticationDetailsSource casAuthenticationDetailsSource, ServiceProperties casServiceProperties, SessionMappingStorage casSessionMappingStorage) {
        CasAuthenticationFilter casAuthenticationFilter = new CasAuthenticationFilter();
        casAuthenticationFilter.setFilterProcessesUrl("/" + CasSecurityRealm.getFinishLoginUrl());
        casAuthenticationFilter.setAuthenticationManager(casAuthenticationManager);
        casAuthenticationFilter.setAuthenticationDetailsSource((AuthenticationDetailsSource)casAuthenticationDetailsSource);
        casAuthenticationFilter.setServiceProperties(casServiceProperties);
        casAuthenticationFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new CasSessionFixationProtectionStrategy(casSessionMappingStorage));
        casAuthenticationFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler("/" + CasSecurityRealm.getFailedLoginUrl()));
        casAuthenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new SessionUrlAuthenticationSuccessHandler("/"));
        casAuthenticationFilter.setContinueChainBeforeSuccessfulAuthentication(true);
        return casAuthenticationFilter;
    }

    @Bean
    public ChainedServletFilter casFilter(HttpSessionContextIntegrationFilter2 httpSessionContextIntegrationFilter, CasSingleSignOutFilter casSingleSignOutFilter, CasAuthenticationFilter casAuthenticationFilter) {
        return new ChainedServletFilter(new Filter[]{httpSessionContextIntegrationFilter, casSingleSignOutFilter, casAuthenticationFilter});
    }

    @Bean
    public CasRestAuthenticator casRestAuthenticator(CasSecurityRealm securityRealm, AuthenticationManager casAuthenticationManager, DynamicServiceAuthenticationDetailsSource casAuthenticationDetailsSource) {
        CasRestAuthenticator casRestAuthenticator = new CasRestAuthenticator();
        casRestAuthenticator.setCasServerUrl(securityRealm.casServerUrl);
        casRestAuthenticator.setAuthenticationManager(casAuthenticationManager);
        casRestAuthenticator.setAuthenticationDetailsSource(casAuthenticationDetailsSource);
        return casRestAuthenticator;
    }
}

