/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.protocols;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.List;
import jenkins.model.Jenkins;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jasig.cas.client.validation.TicketValidator;
import org.jenkinsci.plugins.cas.CasProtocol;
import org.jenkinsci.plugins.cas.Messages;
import org.jenkinsci.plugins.cas.validation.Cas10RoleParsingTicketValidator;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedClasspathException;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Cas10Protocol
extends CasProtocol {
    public final String rolesValidationScript;
    public final String testValidationResponse;
    public final boolean sandbox;
    private final SecureGroovyScript secureRolesValidationScript;

    @Deprecated
    public Cas10Protocol(String rolesValidationScript, String testValidationResponse) {
        this(rolesValidationScript, testValidationResponse, false);
    }

    @DataBoundConstructor
    public Cas10Protocol(String rolesValidationScript, String testValidationResponse, boolean sandbox) {
        super("roles");
        this.rolesValidationScript = Util.fixEmptyAndTrim((String)rolesValidationScript);
        this.testValidationResponse = Util.fixEmpty((String)testValidationResponse);
        this.sandbox = sandbox;
        this.secureRolesValidationScript = Cas10Protocol.getSecureGroovyScript(this.rolesValidationScript, this.sandbox);
    }

    @Override
    public TicketValidator createTicketValidator(String casServerUrl) {
        Cas10RoleParsingTicketValidator ticketValidator = new Cas10RoleParsingTicketValidator(casServerUrl);
        ticketValidator.setRolesValidationScript(this.secureRolesValidationScript);
        return ticketValidator;
    }

    private static SecureGroovyScript getSecureGroovyScript(String script, boolean sandbox) {
        if (script == null) {
            return null;
        }
        return new SecureGroovyScript(script, sandbox, null).configuringWithKeyItem();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<CasProtocol> {
        public String getDisplayName() {
            return "CAS 1.0";
        }

        public FormValidation doTestScript(@QueryParameter(value="rolesValidationScript") String rolesValidationScript, @QueryParameter(value="testValidationResponse") String testValidationResponse, @QueryParameter(value="sandbox") boolean sandbox) {
            if (!this.canRunScripts()) {
                return FormValidation.error((String)Messages.Cas10Protocol_rolesValidationScript_noRunScriptPermissionError());
            }
            try {
                List<String> roles = Cas10RoleParsingTicketValidator.parseRolesFromValidationResponse(Cas10Protocol.getSecureGroovyScript(rolesValidationScript, sandbox), testValidationResponse);
                if (roles == null) {
                    return FormValidation.warning((String)Messages.Cas10Protocol_rolesValidationScript_noResult());
                }
                return FormValidation.ok((String)(Messages.Cas10Protocol_rolesValidationScript_result() + ": " + roles));
            }
            catch (CompilationFailedException e) {
                return FormValidation.error((String)(Messages.Cas10Protocol_rolesValidationScript_compilationError() + ": " + (Object)((Object)e)));
            }
            catch (ClassCastException e) {
                return FormValidation.error((String)(Messages.Cas10Protocol_rolesValidationScript_returnTypeError() + ": " + e));
            }
            catch (RejectedAccessException e) {
                return FormValidation.error((String)(Messages.Cas10Protocol_rolesValidationScript_rejectedAccessError() + ": " + (Object)((Object)e)));
            }
            catch (UnapprovedUsageException e) {
                return FormValidation.error((String)(Messages.Cas10Protocol_rolesValidationScript_unapprovedUsageError() + ": " + (Object)((Object)e)));
            }
            catch (UnapprovedClasspathException e) {
                return FormValidation.error((String)(Messages.Cas10Protocol_rolesValidationScript_unapprovedClasspathError() + ": " + (Object)((Object)e)));
            }
            catch (Exception e) {
                return FormValidation.error((String)(Messages.Cas10Protocol_rolesValidationScript_unknownError() + ": " + e));
            }
        }

        private boolean canRunScripts() {
            return Jenkins.get().getACL().hasPermission(Jenkins.ADMINISTER);
        }
    }
}

