/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.validation;

import groovy.lang.Binding;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jenkins.model.Jenkins;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.AbstractCasProtocolUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;

public class Cas10RoleParsingTicketValidator
extends AbstractCasProtocolUrlBasedTicketValidator {
    public static final String DEFAULT_ROLE_ATTRIBUTE = "roles";
    private SecureGroovyScript rolesValidationScript;
    private String rolesAttribute = "roles";

    public Cas10RoleParsingTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    protected String getUrlSuffix() {
        return "validate";
    }

    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        if (!response.startsWith("yes")) {
            throw new TicketValidationException("CAS Server could not validate ticket.");
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(response));
            reader.readLine();
            String name = reader.readLine();
            List<String> roles = Cas10RoleParsingTicketValidator.parseRolesFromValidationResponse(this.rolesValidationScript, response);
            if (roles != null) {
                HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(1);
                attributes.put(this.rolesAttribute, roles);
                AttributePrincipalImpl principal = new AttributePrincipalImpl(name, attributes);
                return new AssertionImpl((AttributePrincipal)principal);
            }
            return new AssertionImpl(name);
        }
        catch (Exception e) {
            throw new TicketValidationException("Unable to parse response.", (Throwable)e);
        }
    }

    public static List<String> parseRolesFromValidationResponse(SecureGroovyScript script, String response) throws Exception {
        if (script == null) {
            return null;
        }
        Binding binding = new Binding();
        binding.setVariable("response", (Object)response);
        Collection coll = (Collection)script.evaluate(Jenkins.get().getPluginManager().uberClassLoader, binding, null);
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>(coll.size());
        for (Object obj : coll) {
            if (obj == null) continue;
            roles.add(obj.toString());
        }
        return roles;
    }

    public SecureGroovyScript getRolesValidationScript() {
        return this.rolesValidationScript;
    }

    public void setRolesValidationScript(SecureGroovyScript rolesValidationScript) {
        this.rolesValidationScript = rolesValidationScript;
    }

    public String getRolesAttribute() {
        return this.rolesAttribute;
    }

    public void setRolesAttribute(String rolesAttribute) {
        this.rolesAttribute = rolesAttribute;
    }
}

