/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import javax.servlet.http.HttpServletRequest;
import org.jenkinsci.plugins.cas.CasSecurityRealm;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;

public class DynamicServiceAuthenticationDetails
implements ServiceAuthenticationDetails {
    private static final long serialVersionUID = 1L;
    private String serviceUrl;

    public DynamicServiceAuthenticationDetails(HttpServletRequest request, ServiceProperties serviceProperties) {
        this.serviceUrl = CasSecurityRealm.getServiceUrl(request, serviceProperties);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.serviceUrl.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof DynamicServiceAuthenticationDetails)) {
            return false;
        }
        ServiceAuthenticationDetails that = (ServiceAuthenticationDetails)obj;
        return this.serviceUrl.equals(that.getServiceUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceUrl: ").append(this.serviceUrl);
        return sb.toString();
    }
}

