/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.util.StringUtils;

public class SessionUrlAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    public static final String DEFAULT_TARGET_URL_SESSION_ATTRIBUTE = "spring-security-redirect";
    private String targetUrlSessionAttribute = "spring-security-redirect";

    public SessionUrlAuthenticationSuccessHandler(String defaultTargetUrl) {
        super(defaultTargetUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl = null;
        HttpSession session = request.getSession(false);
        if (session != null && this.targetUrlSessionAttribute != null) {
            targetUrl = (String)session.getAttribute(this.targetUrlSessionAttribute);
            session.removeAttribute(this.targetUrlSessionAttribute);
        }
        if (this.isAlwaysUseDefaultTargetUrl() || !StringUtils.hasText(targetUrl) || this.getTargetUrlParameter() != null && StringUtils.hasText((String)request.getParameter(this.getTargetUrlParameter()))) {
            return super.determineTargetUrl(request, response);
        }
        this.logger.debug((Object)("Found targetUrlSessionAttribute in request: " + targetUrl));
        if (targetUrl.startsWith(request.getContextPath())) {
            return targetUrl.substring(request.getContextPath().length());
        }
        return targetUrl;
    }

    public String getTargetUrlSessionAttribute() {
        return this.targetUrlSessionAttribute;
    }

    public void setTargetUrlSessionAttribute(String targetUrlSessionAttribute) {
        this.targetUrlSessionAttribute = targetUrlSessionAttribute;
    }
}

