/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import java.io.Serializable;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.authentication.CasAuthenticationToken;

public class CasAuthentication
extends AbstractAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object credentials;
    private final Object principal;
    private final UserDetails userDetails;
    private final int keyHash;
    private final Assertion assertion;

    public CasAuthentication(String key, Object principal, Object credentials, GrantedAuthority[] authorities, UserDetails userDetails, Assertion assertion) {
        this(key.hashCode(), principal, credentials, authorities, userDetails, assertion);
    }

    public CasAuthentication(int keyHash, Object principal, Object credentials, GrantedAuthority[] authorities, UserDetails userDetails, Assertion assertion) {
        super(authorities);
        if (principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || userDetails == null || assertion == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = keyHash;
        this.principal = principal;
        this.credentials = credentials;
        this.userDetails = userDetails;
        this.assertion = assertion;
        this.setAuthenticated(true);
    }

    public static CasAuthentication newInstance(CasAuthenticationToken casToken) {
        GrantedAuthority[] authorities = new GrantedAuthority[casToken.getAuthorities().size()];
        int i = 0;
        for (org.springframework.security.core.GrantedAuthority authority : casToken.getAuthorities()) {
            authorities[i++] = new GrantedAuthorityImpl(authority.getAuthority());
        }
        org.springframework.security.core.userdetails.User sourceUser = (org.springframework.security.core.userdetails.User)casToken.getUserDetails();
        User user = new User(sourceUser.getUsername(), "NO_PASSWORD", sourceUser.isEnabled(), sourceUser.isAccountNonExpired(), sourceUser.isCredentialsNonExpired(), sourceUser.isAccountNonLocked(), authorities);
        return new CasAuthentication(casToken.getKeyHash(), (Object)user, casToken.getCredentials(), authorities, (UserDetails)user, casToken.getAssertion());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof CasAuthentication) {
            CasAuthentication test = (CasAuthentication)obj;
            if (!this.assertion.equals(test.getAssertion())) {
                return false;
            }
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" Assertion: ").append(this.assertion);
        sb.append(" Credentials (Service/Proxy Ticket): ").append(this.credentials);
        return sb.toString();
    }
}

