/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.protocols;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.validation.Cas30ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.TicketValidator;
import org.jenkinsci.plugins.cas.CasProtocol;
import org.kohsuke.stapler.DataBoundConstructor;

public class Cas30Protocol
extends CasProtocol {
    public final Boolean proxyEnabled;
    public final Boolean proxyAllowAny;
    public final String proxyAllowList;

    @DataBoundConstructor
    public Cas30Protocol(String authoritiesAttribute, String fullNameAttribute, String emailAttribute, Boolean proxyEnabled, Boolean proxyAllowAny, String proxyAllowList) {
        this.authoritiesAttribute = Util.fixEmptyAndTrim((String)authoritiesAttribute);
        this.fullNameAttribute = Util.fixEmptyAndTrim((String)fullNameAttribute);
        this.emailAttribute = Util.fixEmptyAndTrim((String)emailAttribute);
        this.proxyEnabled = proxyEnabled;
        this.proxyAllowAny = proxyAllowAny;
        this.proxyAllowList = proxyAllowList;
    }

    @Override
    public TicketValidator createTicketValidator(String casServerUrl) {
        if (this.proxyEnabled != null && this.proxyEnabled.booleanValue()) {
            Cas30ProxyTicketValidator ptv = new Cas30ProxyTicketValidator(casServerUrl);
            ptv.setAcceptAnyProxy(this.proxyAllowAny.booleanValue());
            String[] proxyChain = StringUtils.split((String)this.proxyAllowList, (char)'\n');
            if (proxyChain != null && proxyChain.length > 0) {
                ArrayList<String[]> proxyList = new ArrayList<String[]>(1);
                proxyList.add(proxyChain);
                ptv.setAllowedProxyChains(new ProxyList(proxyList));
            }
            return ptv;
        }
        return new Cas30ServiceTicketValidator(casServerUrl);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<CasProtocol> {
        public String getDisplayName() {
            return "CAS 3.0";
        }
    }
}

