/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas;

import groovy.lang.Binding;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.security.ChainedServletFilter;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.jenkinsci.plugins.cas.CasProtocol;
import org.jenkinsci.plugins.cas.Messages;
import org.jenkinsci.plugins.cas.spring.security.AcegiAuthenticationManager;
import org.jenkinsci.plugins.cas.spring.security.CasRestAuthenticator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.context.WebApplicationContext;

public class CasSecurityRealm
extends SecurityRealm {
    public static final String DEFAULT_COMMENCE_LOGIN_URL = "securityRealm/commenceLogin";
    public static final String DEFAULT_FINISH_LOGIN_URL = "securityRealm/finishLogin";
    public static final String DEFAULT_FAILED_LOGIN_URL = "securityRealm/failedLogin";
    public final String casServerUrl;
    public final CasProtocol casProtocol;
    public final Boolean forceRenewal;
    public final Boolean enableSingleSignOut;
    public final Boolean enableRestApi;
    private transient WebApplicationContext applicationContext;

    @Deprecated
    public CasSecurityRealm(String casServerUrl, CasProtocol casProtocol, Boolean forceRenewal, Boolean enableSingleSignOut) {
        this(casServerUrl, casProtocol, forceRenewal, enableSingleSignOut, false);
    }

    @DataBoundConstructor
    public CasSecurityRealm(String casServerUrl, CasProtocol casProtocol, Boolean forceRenewal, Boolean enableSingleSignOut, Boolean enableRestApi) {
        this.casServerUrl = StringUtils.stripEnd((String)casServerUrl, (String)"/") + "/";
        this.casProtocol = casProtocol;
        this.forceRenewal = forceRenewal;
        this.enableSingleSignOut = enableSingleSignOut;
        this.enableRestApi = enableRestApi;
    }

    public static String getJenkinsUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    public static String getJenkinsUrl(HttpServletRequest req) {
        String jenkinsUrl = CasSecurityRealm.getJenkinsUrl();
        if (jenkinsUrl == null && req != null) {
            jenkinsUrl = UrlUtils.buildFullRequestUrl((String)req.getScheme(), (String)req.getServerName(), (int)req.getServerPort(), (String)req.getContextPath(), null) + "/";
        }
        return jenkinsUrl;
    }

    public static String getFinishLoginUrl() {
        return DEFAULT_FINISH_LOGIN_URL;
    }

    public static String getFailedLoginUrl() {
        return DEFAULT_FAILED_LOGIN_URL;
    }

    public static String getServiceUrl(HttpServletRequest req, ServiceProperties serviceProperties) {
        String serviceUrl = serviceProperties.getService();
        if (serviceUrl != null && !serviceUrl.startsWith("http")) {
            serviceUrl = CasSecurityRealm.getJenkinsUrl(req) + serviceUrl;
        }
        return serviceUrl;
    }

    protected WebApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            Binding binding = new Binding();
            binding.setVariable("securityRealm", (Object)this);
            binding.setVariable("casProtocol", (Object)this.casProtocol);
            BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
            builder.parse(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".groovy"), binding);
            this.applicationContext = builder.createApplicationContext();
        }
        return this.applicationContext;
    }

    protected CasRestAuthenticator getCasRestAuthenticator() {
        return (CasRestAuthenticator)this.getApplicationContext().getBean("casRestAuthenticator");
    }

    protected boolean isRestApiEnabled() {
        return Boolean.TRUE.equals(this.enableRestApi);
    }

    public String getLoginUrl() {
        return DEFAULT_COMMENCE_LOGIN_URL;
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        StringBuilder logoutUrlBuilder = new StringBuilder(this.casServerUrl);
        logoutUrlBuilder.append("logout?service=");
        try {
            logoutUrlBuilder.append(URLEncoder.encode(CasSecurityRealm.getJenkinsUrl(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return logoutUrlBuilder.toString();
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                if (authentication instanceof UsernamePasswordAuthenticationToken && CasSecurityRealm.this.isRestApiEnabled()) {
                    return new AcegiAuthenticationManager(CasSecurityRealm.this.getCasRestAuthenticator()).authenticate(authentication);
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        });
    }

    public Filter createFilter(FilterConfig filterConfig) {
        Filter defaultFilter = super.createFilter(filterConfig);
        Filter casFilter = (Filter)this.getApplicationContext().getBean("casFilter");
        return new ChainedServletFilter(new Filter[]{casFilter, defaultFilter});
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        HttpSession session = req.getSession(false);
        if (session != null) {
            SessionMappingStorage sessionMappingStorage = (SessionMappingStorage)this.getApplicationContext().getBean("casSessionMappingStorage");
            sessionMappingStorage.removeBySessionById(session.getId());
        }
        super.doLogout(req, rsp);
    }

    public void doCommenceLogin(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        AuthenticationEntryPoint entryPoint = (AuthenticationEntryPoint)this.getApplicationContext().getBean("casAuthenticationEntryPoint");
        entryPoint.commence((HttpServletRequest)req, (HttpServletResponse)rsp, null);
    }

    public void doFinishLogin(StaplerRequest req, StaplerResponse rsp) {
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "CAS (Central Authentication Service)";
        }

        public FormValidation doCheckCasServerUrl(@QueryParameter String value) throws IOException, ServletException {
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.error((String)Messages.CasSecurityRealm_casServerUrl_missingUrl());
            }
            try {
                URL url = new URL(StringUtils.stripEnd((String)value, (String)"/") + "/login");
                String response = CommonUtils.getResponseFromServer((URL)url, (String)"UTF-8");
                if (!response.contains("username")) {
                    return FormValidation.warning((String)Messages.CasSecurityRealm_casServerUrl_invalidResponse());
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)(Messages.CasSecurityRealm_casServerUrl_malformedUrl() + ": " + e.getMessage()));
            }
            catch (RuntimeException e) {
                return FormValidation.error((String)(Messages.CasSecurityRealm_casServerUrl_cannotGetResponse() + ": " + (e.getCause() == null ? e : e.getCause())));
            }
            return FormValidation.ok();
        }
    }
}

