/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.util;

import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.util.FormValidation;
import java.util.regex.Pattern;

public class BumblebeeUtils {
    private static final String REQUIRED = "Required";

    public static FormValidation validateCustomProperties(String customProperties) {
        try {
            String t = Util.fixEmptyAndTrim((String)customProperties);
            Pattern p = Pattern.compile("(\\w+)=\"*((?<=\")[^\"]+(?=\")|([^\\s]+))\"*");
            if (p.matcher(t).matches()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Custom properties should be name=value and seperated by commas");
        }
        catch (Exception anye) {
            return FormValidation.error((String)("Custom properties should be name=value and seperated by commas " + anye.getMessage()));
        }
    }

    public static FormValidation validateqcUrl(String qcUrl) {
        String t = Util.fixEmptyAndTrim((String)qcUrl);
        if (t == null || !t.matches("^(https?)\\:\\/\\/[0-9a-zA-Z]([-.\\w]*[0-9a-zA-Z])*(:\\d*[^\\/])?\\/qcbin$")) {
            return FormValidation.error((String)"Url should be http(s)://<qcserver>:<qcport>/qcbin");
        }
        return FormValidation.ok();
    }

    public static FormValidation validateRequiredField(String fieldValue) {
        String preparedVal = Util.fixEmptyAndTrim((String)fieldValue);
        if (preparedVal == null) {
            return FormValidation.error((String)REQUIRED);
        }
        return FormValidation.ok();
    }

    public static FormValidation validateTestPlan(String testPlan) {
        String t = Util.fixEmptyAndTrim((String)testPlan);
        if (t == null) {
            return FormValidation.error((String)REQUIRED);
        }
        if (!t.startsWith("Subject\\") || t.contains("^") || t.contains("*")) {
            return FormValidation.error((String)"Test Plan must begin with 'Subject\\' and cannot contain '^' or '*'");
        }
        return FormValidation.ok();
    }

    public static FormValidation validateTestLab(String testLab) {
        return BumblebeeUtils.validateTestLab(testLab, "Test Lab");
    }

    public static FormValidation validateTestLab(String testLabPath, String paramName) {
        String t = Util.fixEmptyAndTrim((String)testLabPath);
        if (t == null) {
            return FormValidation.error((String)REQUIRED);
        }
        if (!t.startsWith("Root\\") || t.contains("^") || t.contains("*")) {
            return FormValidation.error((String)(paramName + " must begin with 'Root\\' and cannot contain '^' or '*'"));
        }
        return FormValidation.ok();
    }

    public static FormValidation validateTestSet(String testSet) {
        String t = Util.fixEmptyAndTrim((String)testSet);
        if (t == null) {
            return FormValidation.error((String)REQUIRED);
        }
        if (t.contains("^") || t.contains(",") || t.contains("\"") || t.contains("*")) {
            return FormValidation.error((String)"Test Set value cannot contain these characters ^ , \" *");
        }
        return FormValidation.ok();
    }

    public static String maskPasswordInString(String strWithPassword) {
        return strWithPassword.replaceAll("password=[^&]*", "password=*******");
    }

    public static String maskPasswordInResponse(String xmlResponse) {
        return BumblebeeUtils.maskPasswordInString(xmlResponse.replaceAll("<encrypted_password>[^<]*", "<encrypted_password>*******"));
    }

    public static FilePath getWorkspace(AbstractBuild build) {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            workspace = build.getProject().getSomeWorkspace();
        }
        return workspace;
    }
}

