/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.pc;

import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.client.api.BumblebeeApi;
import com.agiletestware.bumblebee.client.api.BumblebeeApiProvider;
import com.agiletestware.bumblebee.client.pc.RunPcTestContext;
import com.agiletestware.bumblebee.client.utils.action.RetrySettings;
import com.agiletestware.bumblebee.encryption.CustomSecret;
import com.agiletestware.bumblebee.pc.PcConnectionParameters;
import com.agiletestware.bumblebee.pc.RunPcTestBuildStep;
import com.agiletestware.bumblebee.pc.StartRunParameters;
import hudson.FilePath;
import hudson.Util;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class RunPcTestContextImpl
implements RunPcTestContext,
Serializable {
    private static final double DEFAULT_RETRY_INTERVAL_MULTIPLY_FACTORY = 1.0;
    private static final long serialVersionUID = 3758920973453470489L;
    private final StartRunParameters parameters;
    private final PcConnectionParameters connectionParameters;
    private final RetrySettings genericRetrySettings;
    private final RetrySettings collateAnalyzeRetrySettings;
    private final int pollingInterval;
    private final File outputDir;
    private final String bumblebeeUrl;
    private final int connectionTimeOut;

    public RunPcTestContextImpl(RunPcTestBuildStep buildStep, BumblebeeGlobalConfig globalConfig, FilePath workspace, CustomSecret customSecret, BumblebeeApiProvider bumblebeeApiProvider) throws Exception {
        this.parameters = this.createStartRunParameters(buildStep);
        this.connectionParameters = new PcConnectionParametersImpl(globalConfig, buildStep.getDomain(), buildStep.getProject(), buildStep.getAlmUser(), buildStep.getAlmPassword(), customSecret, bumblebeeApiProvider);
        this.bumblebeeUrl = globalConfig.getBumblebeeUrl();
        this.connectionTimeOut = (int)TimeUnit.MINUTES.toSeconds(this.getTimeout(buildStep, globalConfig));
        this.genericRetrySettings = new RetrySettings(buildStep.getRetryCount(), buildStep.getRetryInterval(), buildStep.getRetryIntervalMultiplier());
        this.collateAnalyzeRetrySettings = this.createCollateAnalyzeRetrySettings(buildStep);
        this.pollingInterval = buildStep.getPollingInterval();
        this.outputDir = new File(workspace.getRemote(), buildStep.getOutputDir());
    }

    private StartRunParameters createStartRunParameters(RunPcTestBuildStep buildStep) {
        StartRunParameters parameters = new StartRunParameters();
        parameters.setPostRunAction(buildStep.getPostRunAction());
        parameters.setTestPath(buildStep.getTestPlanPath());
        parameters.setTestSetPath(buildStep.getTestLabPath());
        parameters.setTimeslotDuration(buildStep.getTimeslotDuration());
        parameters.setVudsMode(buildStep.isVudsMode());
        return parameters;
    }

    private int getTimeout(RunPcTestBuildStep buildStep, BumblebeeGlobalConfig globalConfig) {
        int timeout = buildStep.getTimeout();
        return timeout > 0 ? timeout : globalConfig.getPcTimeOut();
    }

    public String getBumblebeeUrl() {
        return this.bumblebeeUrl;
    }

    public int getTimeout() {
        return this.connectionTimeOut;
    }

    public PcConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public StartRunParameters getStartRunParameters() {
        return this.parameters;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public RetrySettings getGenericRetrySettings() {
        return this.genericRetrySettings;
    }

    public RetrySettings getCollateAnalyzeRetrySettings() {
        return this.collateAnalyzeRetrySettings;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    private RetrySettings createCollateAnalyzeRetrySettings(RunPcTestBuildStep buildStep) {
        boolean enableRetry = buildStep.isRetryCollateAndAnalysisFlag();
        return enableRetry ? new RetrySettings(buildStep.getRetryCollateAndAnalysisAttempts(), buildStep.getRetryCollateAndAnalysisInterval(), 1.0) : new RetrySettings(0, 0, 1.0);
    }

    private static class PcConnectionParametersImpl
    implements PcConnectionParameters,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final CustomSecret customSecret;
        private final BumblebeeApiProvider bumblebeeApiProvider;
        private final String project;
        private final String domain;
        private final String almUrl;
        private final String user;
        private final String pcUrl;
        private final String password;

        public PcConnectionParametersImpl(BumblebeeGlobalConfig globalConfig, String domain, String project, String almUser, String almPassword, CustomSecret customSecret, BumblebeeApiProvider bumblebeeApiProvider) throws Exception {
            this.project = project;
            this.domain = domain;
            this.almUrl = globalConfig.getQcUrl();
            String almUserFromStep = Util.fixEmptyAndTrim((String)almUser);
            this.customSecret = customSecret;
            this.bumblebeeApiProvider = bumblebeeApiProvider;
            this.user = StringUtils.isNotEmpty((String)almUserFromStep) ? almUserFromStep : globalConfig.getQcUserName();
            this.pcUrl = globalConfig.getPcUrl();
            this.password = this.getEncryptedAlmPassword(globalConfig, almPassword);
        }

        public String getUser() {
            return this.user;
        }

        public String getProject() {
            return this.project;
        }

        public String getPcUrl() {
            return this.pcUrl;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getAlmUrl() {
            return this.almUrl;
        }

        private String getEncryptedAlmPassword(BumblebeeGlobalConfig globalConfig, String almPasswordFromStep) throws Exception {
            if (StringUtils.isEmpty((String)almPasswordFromStep)) {
                return globalConfig.getPassword();
            }
            String bumblebeeUrl = globalConfig.getBumblebeeUrl();
            if (StringUtils.isEmpty((String)bumblebeeUrl)) {
                throw new IllegalStateException("Bumblebee URL is not defined in Bumblebee Global Configuration");
            }
            try (BumblebeeApi bumblebeeApi = this.bumblebeeApiProvider.provide(bumblebeeUrl, (int)TimeUnit.MINUTES.toSeconds(globalConfig.getTimeOut()));){
                String string = bumblebeeApi.getEncryptedPassword(this.customSecret.getPlainText(almPasswordFromStep));
                return string;
            }
        }
    }
}

