/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee;

import com.agiletestware.bumblebee.JenkinsBuildLogger;
import com.agiletestware.bumblebee.client.api.BulkUpdateParameters;
import com.agiletestware.bumblebee.client.api.BumblebeeApiProvider;
import com.agiletestware.bumblebee.client.api.DefaultBumblebeeApiProvider;
import com.agiletestware.bumblebee.client.uploader.ReportFilesUploaderFactory;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.remoting.RoleChecker;

public class BumblebeeRemoteExecutor
implements Callable<Void, Exception>,
Serializable {
    private static final long serialVersionUID = 3670838509646174454L;
    private final JenkinsBuildLogger log;
    private final FilePath workspace;
    private final BulkUpdateParameters parameters;

    public BumblebeeRemoteExecutor(FilePath workspace, BulkUpdateParameters parameters, TaskListener listener) {
        this.workspace = workspace;
        this.parameters = parameters;
        this.log = new JenkinsBuildLogger(listener);
    }

    public Void call() throws Exception {
        this.execute();
        return null;
    }

    public void execute() throws Exception {
        List<File> filesToBeUploaded = this.locateBumbleBeeReports(this.workspace, this.parameters.getResultPattern());
        ReportFilesUploaderFactory.getReportFilesUploader((String)this.parameters.getFormat()).sendReportFiles((BumblebeeApiProvider)new DefaultBumblebeeApiProvider(), this.parameters, (BuildLogger)this.log, filesToBeUploaded, this.workspace.getRemote());
    }

    private List<File> locateBumbleBeeReports(FilePath workspace, String pattern) throws IOException, InterruptedException {
        ArrayList<File> files = new ArrayList<File>();
        try {
            FilePath[] filePaths = workspace.list(pattern);
            if (filePaths.length > 0) {
                for (FilePath filePath : filePaths) {
                    files.add(new File(filePath.getRemote()));
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error occurred during the search with pattern: " + pattern + ", error: " + ex.getMessage(), ex);
        }
        return files;
    }

    public void checkRoles(RoleChecker arg0) throws SecurityException {
    }
}

