/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee;

import com.agiletestware.bumblebee.BulkUpdateEnvSpecificParameters;
import com.agiletestware.bumblebee.BumblebeeConfiguration;
import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.BumblebeeRemoteExecutor;
import com.agiletestware.bumblebee.client.api.BaseParameters;
import com.agiletestware.bumblebee.client.api.BulkUpdateParameters;
import com.agiletestware.bumblebee.client.api.BulkUpdateParametersImpl;
import com.agiletestware.bumblebee.util.BumblebeeUtils;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class BumblebeePublisher
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(BumblebeePublisher.class.getName());
    private final BumblebeeConfiguration[] configs;

    public BumblebeePublisher(BumblebeeConfiguration ... configs) {
        this.configs = configs;
    }

    @DataBoundConstructor
    public BumblebeePublisher(Collection<BumblebeeConfiguration> configs) {
        this(configs.toArray(new BumblebeeConfiguration[configs.size()]));
    }

    public List<BumblebeeConfiguration> getConfigs() {
        if (this.configs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.configs);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean success = true;
        for (BumblebeeConfiguration config : this.getConfigs()) {
            try {
                this.doBulkUpdate(config, run, workspace, launcher, listener);
            }
            catch (Throwable ex) {
                listener.getLogger().println(ex.getMessage());
                LOGGER.log(Level.SEVERE, null, ex);
                if (config.getFailIfUploadFailed()) {
                    listener.getLogger().println("Bumblebee: Fail if upload flag is set to true -> mark build as failed");
                    success = false;
                    continue;
                }
                listener.getLogger().println("Bumblebee: Fail if upload flag is set to false -> ignore errors in the build step");
            }
        }
        if (!success) {
            throw new AbortException("Bumblebee: Fail if upload flag is set to true -> mark build as failed");
        }
    }

    public void doBulkUpdate(BumblebeeConfiguration config, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws Exception {
        BumblebeeGlobalConfig globalConfig = (BumblebeeGlobalConfig)((Object)GlobalConfiguration.all().get(BumblebeeGlobalConfig.class));
        BulkUpdateParametersImpl params = new BulkUpdateParametersImpl();
        globalConfig.populateBaseParameters((BaseParameters)params);
        params.setDomain(config.getDomain());
        params.setProject(config.getProjectName());
        params.setFormat(config.getFormat());
        params.setTestPlanDirectory(config.getTestPlan());
        params.setTestLabDirectory(config.getTestLab());
        params.setTestSet(config.getTestSet());
        params.setResultPattern(config.getResultPattern());
        params.setMode(config.getMode());
        params.setTimeOut(globalConfig.getTimeOut());
        params.setCustomProperties(config.getCustomProperties());
        params.setOffline(config.isOffline());
        PrintStream logger = listener.getLogger();
        BumblebeeRemoteExecutor remoteExecutor = new BumblebeeRemoteExecutor(workspace, new BulkUpdateEnvSpecificParameters((BulkUpdateParameters)params, run.getEnvironment(listener)), listener);
        try {
            launcher.getChannel().call((Callable)remoteExecutor);
        }
        catch (Throwable e) {
            logger.println(e);
            e.printStackTrace(logger);
            throw e;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String PLUGIN_HELP_PAGE_URI = "/plugin/bumblebee/help/main.html";
        private static final String PLUGIN_DISPLAY_NAME = "Bumblebee  HP  ALM  Uploader";

        public DescriptorImpl() {
            super(BumblebeePublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return PLUGIN_DISPLAY_NAME;
        }

        public String getHelpFile() {
            return PLUGIN_HELP_PAGE_URI;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public BumblebeePublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new BumblebeePublisher(req.bindParametersToList(BumblebeeConfiguration.class, "Bumblebee.bumblebeeConfiguration."));
        }

        public FormValidation doCheckDomain(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String domain) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(domain);
        }

        public FormValidation doCheckProjectName(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String projectName) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(projectName);
        }

        public FormValidation doCheckTestPlan(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String testPlan) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateTestPlan(testPlan);
        }

        public FormValidation doCheckTestLab(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String testLab) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateTestLab(testLab);
        }

        public FormValidation doCheckTestSet(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String testSet) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateTestSet(testSet);
        }

        public FormValidation doCheckFormat(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String format) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(format);
        }
    }
}

