/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildgraphview;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.BallColor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;

public class BuildExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Run build;
    private final int buildIndex;
    private String id;
    private String buildUrl;
    private String startTime;
    private String buildName;
    private String buildNumber;
    private BallColor iconColor;
    private String fullDisplayName;
    private String description;
    private boolean building;
    private String durationString;
    private String buildSummaryStatusString;
    private int displayColumn;
    private int displayRow;
    private List<String> parameters = null;

    public BuildExecution(Run build, int buildIndex) {
        this.build = build;
        this.buildIndex = buildIndex;
        this.id = "build-" + buildIndex;
        this.buildUrl = this.getBuildFromUtil().getAbsoluteUrl();
        this.startTime = this.isStarted() ? DateFormat.getDateTimeInstance(3, 3).format(build.getTime()) : "";
        this.buildName = this.getBuildFromUtil().getParent().getName();
        this.buildNumber = "" + this.getBuildFromUtil().number;
        this.iconColor = this.getBuildFromUtil().getIconColor();
        this.fullDisplayName = this.getBuildFromUtil().getFullDisplayName();
        this.description = this.getBuildFromUtil().getDescription();
        this.building = this.getBuildFromUtil().isBuilding();
        this.durationString = this.getBuildFromUtil().getDurationString();
        this.buildSummaryStatusString = this.getBuildFromUtil().getBuildStatusSummary().message;
        ParametersAction parameters = (ParametersAction)this.getBuildFromUtil().getAction(ParametersAction.class);
        if (parameters != null) {
            this.parameters = new LinkedList<String>();
            for (ParameterValue p : parameters.getParameters()) {
                if (p == null) continue;
                String paramString = p.toString();
                if (paramString.startsWith("(") && paramString.indexOf(" ") != -1) {
                    this.parameters.add(paramString.substring(paramString.indexOf(" ") + 1));
                    continue;
                }
                this.parameters.add(paramString);
            }
        }
    }

    public BuildExecution(int buildIndex) {
        this.buildIndex = buildIndex;
    }

    public BallColor getIconColor() {
        return this.iconColor;
    }

    public String getFullDisplayName() {
        return this.fullDisplayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getBuilding() {
        return this.building;
    }

    public String getDurationString() {
        return this.durationString;
    }

    public String getbuildSummaryStatusString() {
        return this.buildSummaryStatusString;
    }

    public String getId() {
        return this.id;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getStartTime() {
        if (this.build == null) {
            return this.startTime;
        }
        if (this.isStarted()) {
            this.startTime = DateFormat.getDateTimeInstance(3, 3).format(this.build.getTime());
            return this.startTime;
        }
        return "";
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean isStarted() {
        return this.build != null ? this.build.getTime() != null : true;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public int getBuildIndex() {
        return this.buildIndex;
    }

    public int getDisplayColumn() {
        return this.displayColumn;
    }

    public int getDisplayRow() {
        return this.displayRow;
    }

    public void setDisplayColumn(int displayColumn) {
        this.displayColumn = displayColumn;
    }

    public void setDisplayRow(int displayRow) {
        this.displayRow = displayRow;
    }

    public String toString() {
        return this.buildName != null && this.buildNumber != null ? this.buildName + " #" + this.buildNumber : "";
    }

    private Run getBuildFromUtil() {
        if (this.build == null) {
            throw new NullPointerException("Build has not been started.");
        }
        return this.build;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildExecution) {
            return this.build.equals(((BuildExecution)obj).build);
        }
        return false;
    }

    public int hashCode() {
        if (this.build != null) {
            return this.build.hashCode();
        }
        return super.hashCode();
    }
}

