/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline.extension;

import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.AbstractNameValueHeader;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.PipelineHeaderExtensionDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilteredVariablesHeader
extends AbstractNameValueHeader {
    private List<FilteredVariable> filteredVariables;

    @DataBoundConstructor
    public FilteredVariablesHeader(List<FilteredVariable> filteredVariables) {
        this.filteredVariables = filteredVariables;
    }

    @Override
    public Map<String, String> getParameters(AbstractBuild<?, ?> build) {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        if (this.filteredVariables == null) {
            return returnValue;
        }
        if (build != null) {
            for (FilteredVariable variable : this.filteredVariables) {
                if (!build.getBuildVariables().containsKey(variable.variableName)) continue;
                returnValue.put(variable.variableName, (String)build.getBuildVariables().get(variable.variableName));
            }
            Set sensitiveBuildVariables = build.getSensitiveBuildVariables();
            for (String paramName : sensitiveBuildVariables) {
                if (!returnValue.containsKey(paramName)) continue;
                returnValue.put(paramName, "********");
            }
        }
        return returnValue;
    }

    public List<FilteredVariable> getFilteredVariables() {
        return this.filteredVariables;
    }

    public void setFilteredVariables(List<FilteredVariable> filteredVariables) {
        this.filteredVariables = filteredVariables;
    }

    @Extension
    public static class DescriptorImpl
    extends PipelineHeaderExtensionDescriptor {
        @Override
        public long getIndex() {
            return 5000L;
        }

        public String getDisplayName() {
            return "Specify which build variables";
        }
    }

    public static class FilteredVariable
    extends AbstractDescribableImpl<FilteredVariable> {
        private String variableName;

        @DataBoundConstructor
        public FilteredVariable(String variableName) {
            this.variableName = variableName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<FilteredVariable> {
            public String getDisplayName() {
                return "";
            }
        }
    }
}

