/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline.extension;

import au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.BuildPipelineTrigger;
import au.com.centrumsystems.hudson.plugin.util.BuildUtil;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.util.DescribableList;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class BuildCardExtension
extends AbstractDescribableImpl<BuildCardExtension>
implements ExtensionPoint,
Comparable<BuildCardExtension> {
    private static final Logger LOGGER = Logger.getLogger(BuildCardExtension.class.getName());

    public static ExtensionList<BuildCardExtension> all() {
        return Jenkins.getInstance().getExtensionList(BuildCardExtension.class);
    }

    public abstract long getIndex();

    @Override
    public int compareTo(BuildCardExtension o) {
        return Long.compare(this.getIndex(), o.getIndex());
    }

    public int rerunBuild(String externalizableId) {
        AbstractBuild triggerBuild = (AbstractBuild)Run.fromExternalizableId((String)externalizableId);
        AbstractProject triggerProject = triggerBuild.getProject();
        QueueTaskFuture future = triggerProject.scheduleBuild2(triggerProject.getQuietPeriod(), (Cause)new Cause.UserIdCause(), this.filterActions(triggerBuild.getActions()));
        AbstractBuild result = triggerBuild;
        try {
            result = (AbstractBuild)future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result.getNumber();
    }

    protected List<Action> filterActions(List<Action> actions) {
        ArrayList<Action> retval = new ArrayList<Action>();
        for (Action action : actions) {
            if (action instanceof CauseAction) {
                CauseAction causeAction = this.filterOutUserIdCause((CauseAction)action);
                if (causeAction.getCauses().isEmpty()) continue;
                retval.add((Action)causeAction);
                continue;
            }
            if (action instanceof ParametersAction) {
                retval.add(action);
                continue;
            }
            if (!"hudson.plugins.git.RevisionParameterAction".equals(action.getClass().getName())) continue;
            retval.add(action);
        }
        return retval;
    }

    protected CauseAction filterOutUserIdCause(CauseAction causeAction) {
        ArrayList<Cause> causes = new ArrayList<Cause>();
        for (Cause cause : causeAction.getCauses()) {
            if (cause instanceof Cause.UserIdCause) continue;
            causes.add(cause);
        }
        return new CauseAction(causes);
    }

    public int triggerManualBuild(ItemGroup pipelineContext, Integer upstreamBuildNumber, String triggerProjectName, String upstreamProjectName) {
        AbstractProject triggerProject = (AbstractProject)Jenkins.getInstance().getItem(triggerProjectName, pipelineContext);
        AbstractProject upstreamProject = (AbstractProject)Jenkins.getInstance().getItem(upstreamProjectName, pipelineContext);
        AbstractBuild<?, ?> upstreamBuild = this.retrieveBuild(upstreamBuildNumber, upstreamProject);
        if (upstreamBuild != null) {
            LOGGER.fine("Getting parameters from upstream build " + upstreamBuild.getExternalizableId());
        }
        Action buildParametersAction = null;
        if (upstreamBuild != null) {
            buildParametersAction = BuildUtil.getAllBuildParametersAction(upstreamBuild, triggerProject);
        }
        return this.triggerBuild(triggerProject, upstreamBuild, buildParametersAction);
    }

    protected int triggerBuild(AbstractProject<?, ?> triggerProject, AbstractBuild<?, ?> upstreamBuild, Action buildParametersAction) {
        ParametersAction parametersAction;
        LOGGER.fine("Triggering build for project: " + triggerProject.getFullDisplayName());
        ArrayList<Object> buildActions = new ArrayList<Object>();
        ArrayList<Object> causes = new ArrayList<Object>();
        causes.add(new Cause.UserIdCause());
        if (upstreamBuild != null) {
            causes.add(new Cause.UpstreamCause(upstreamBuild));
        }
        CauseAction causeAction = new CauseAction(causes);
        buildActions.add(causeAction);
        ParametersAction parametersAction2 = parametersAction = buildParametersAction instanceof ParametersAction ? (ParametersAction)buildParametersAction : new ParametersAction(new ParameterValue[0]);
        if (upstreamBuild != null) {
            List<AbstractBuildParameters> configs = this.retrieveUpstreamProjectTriggerConfig(triggerProject, upstreamBuild);
            if (configs == null) {
                LOGGER.log(Level.SEVERE, "No upstream trigger found for this project: " + triggerProject.getFullDisplayName());
                throw new IllegalStateException("No upstream trigger found for this project: " + triggerProject.getFullDisplayName());
            }
            for (AbstractBuildParameters config : configs) {
                try {
                    Action action = config.getAction(upstreamBuild, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
                    if (action instanceof ParametersAction) {
                        parametersAction = BuildCardExtension.mergeParameters(parametersAction, (ParametersAction)action);
                        continue;
                    }
                    buildActions.add(action);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "I/O exception while adding build parameter", e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Adding build parameter was interrupted", e);
                }
                catch (AbstractBuildParameters.DontTriggerException e) {
                    LOGGER.log(Level.FINE, "Not triggering : " + config);
                }
            }
        }
        buildActions.add(parametersAction);
        triggerProject.scheduleBuild(triggerProject.getQuietPeriod(), null, buildActions.toArray(new Action[buildActions.size()]));
        return triggerProject.getNextBuildNumber();
    }

    protected List<AbstractBuildParameters> retrieveUpstreamProjectTriggerConfig(AbstractProject<?, ?> project, AbstractBuild<?, ?> upstreamBuild) {
        BuildPipelineTrigger manualTrigger;
        LOGGER.fine("Looking for triggers in the upstream project: " + upstreamBuild.getProject().getFullName());
        DescribableList upstreamProjectPublishersList = upstreamBuild.getProject().getPublishersList();
        List<Object> configs = null;
        hudson.tasks.BuildTrigger autoTrigger = (hudson.tasks.BuildTrigger)upstreamProjectPublishersList.get(hudson.tasks.BuildTrigger.class);
        if (autoTrigger != null) {
            LOGGER.fine("Found Hudson Trigger (BuildTrigger) found in upstream project publisher list ");
            HashSet downstreamProjectNames = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)autoTrigger.getChildProjectsValue()));
            if (this.triggerIncludes(upstreamBuild.getProject(), project, downstreamProjectNames)) {
                configs = new ArrayList();
            } else {
                LOGGER.warning("Upstream project had a Hudson BuildTrigger for projects [" + downstreamProjectNames + "], but that did not include our project [" + project.getFullName() + "]");
            }
        }
        if ((manualTrigger = (BuildPipelineTrigger)upstreamProjectPublishersList.get(BuildPipelineTrigger.class)) != null) {
            LOGGER.fine("Found Manual Trigger (BuildPipelineTrigger) found in upstream project publisher list ");
            HashSet downstreamProjectsNames = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)manualTrigger.getDownstreamProjectNames()));
            LOGGER.fine("Downstream project names: " + downstreamProjectsNames);
            if (this.triggerIncludes(upstreamBuild.getProject(), project, downstreamProjectsNames)) {
                configs = manualTrigger.getConfigs();
            } else {
                LOGGER.warning("Upstream project had a Manual Trigger for projects [" + downstreamProjectsNames + "], but that did not include our project [" + project.getFullName() + "]");
            }
        } else {
            LOGGER.fine("No manual trigger found");
        }
        BuildTrigger autoParameterizedTrigger = (BuildTrigger)upstreamProjectPublishersList.get(BuildTrigger.class);
        if (autoParameterizedTrigger != null) {
            LOGGER.fine("Found Parameterized Trigger (BuildTrigger) found in upstream project publisher list ");
            for (BuildTriggerConfig config : autoParameterizedTrigger.getConfigs()) {
                HashSet downstreamProjectsNames = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)config.getProjects()));
                if (this.triggerIncludes(upstreamBuild.getProject(), project, downstreamProjectsNames)) {
                    configs = config.getConfigs();
                    continue;
                }
                LOGGER.warning("Upstream project had a Parameterized Trigger (BuildTrigger) for project [" + downstreamProjectsNames + "], but that did not include our project [" + project.getFullName() + "]");
            }
        }
        return configs;
    }

    private boolean triggerIncludes(AbstractProject upstreamProject, AbstractProject downstreamProject, Set<String> downstreamProjectNames) {
        return downstreamProjectNames.contains(downstreamProject.getFullName()) || downstreamProjectNames.contains(downstreamProject.getRelativeNameFrom((Item)upstreamProject));
    }

    protected static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    protected AbstractBuild<?, ?> retrieveBuild(int buildNo, AbstractProject<?, ?> project) {
        AbstractBuild build = null;
        if (project != null) {
            for (AbstractBuild tmpUpBuild : project.getBuilds()) {
                if (tmpUpBuild.getNumber() != buildNo) continue;
                build = tmpUpBuild;
                break;
            }
        }
        return build;
    }
}

