/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.data;

import hudson.model.AbstractProject;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.TreeMap;
import org.jenkinsci.plugins.buildenvironment.data.Data;

public class ProjectData
extends Data {
    public ProjectData(AbstractProject<?, ?> project, String name, String id) {
        super(name, id);
        this.initializeDataMap(project);
    }

    private void initializeDataMap(AbstractProject<?, ?> project) {
        TreeMap<String, String> data = this.initEmptyMap();
        data.put("Project name", project.getName());
        data.put("Project url", project.getUrl());
        data.put("SCM", project.getScm().toString());
        data.put("SCM type", project.getScm().getType());
        data.put("Quiet period", String.valueOf(project.getQuietPeriod()));
        data.put("Block when downstream building", String.valueOf(project.blockBuildWhenDownstreamBuilding()));
        data.put("Block when upstream building", String.valueOf(project.blockBuildWhenUpstreamBuilding()));
        data.put("Abort permission", String.valueOf(project.hasAbortPermission()));
        data.put("Is buildable", String.valueOf(project.isBuildable()));
        data.put("Is concurrent build", String.valueOf(project.isConcurrentBuild()));
        data.put("Is disabled", String.valueOf(project.isDisabled()));
        data.put("Is fingerprint configured", String.valueOf(project.isFingerprintConfigured()));
        data.put("Is parameterized", String.valueOf(project.isParameterized()));
        data.put("Is name editable", String.valueOf(project.isNameEditable()));
        for (TriggerDescriptor i : project.getTriggers().keySet()) {
            data.put(i.getDisplayName(), ((Trigger)project.getTriggers().get(i)).toString());
        }
    }
}

