/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jenkinsci.plugins.buildenvironment.actions.utils.StringPair;
import org.jenkinsci.plugins.buildenvironment.data.Data;

public class DataDifferenceObject {
    private String name;
    private Map<String, StringPair> difMap;

    public DataDifferenceObject(Data data1, Data data2) {
        this.name = data1.getName();
        this.calculateDifference(data1, data2);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, StringPair> getMap() {
        return this.difMap;
    }

    public int getDifferentCount() {
        return this.getDifferenceOnly().size();
    }

    public Map<String, StringPair> getDifferenceOnly() {
        TreeMap<String, StringPair> difOnlyMap = new TreeMap<String, StringPair>();
        for (String key : this.difMap.keySet()) {
            if (!this.difMap.get(key).areDifferent()) continue;
            difOnlyMap.put(key, this.difMap.get(key));
        }
        return difOnlyMap;
    }

    private void calculateDifference(Data data1, Data data2) {
        this.difMap = new TreeMap<String, StringPair>();
        TreeSet<String> keySet = new TreeSet<String>();
        try {
            if (this.canMapBeRetrieved(data1)) {
                keySet.addAll(data1.getData().keySet());
            }
            if (this.canMapBeRetrieved(data2)) {
                keySet.addAll(data2.getData().keySet());
            }
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String key;
                this.difMap.put(key, new StringPair(this.checkMapAttribute(data1, key = (String)iterator.next()) ? data1.getData().get(key) : "", this.checkMapAttribute(data2, key) ? data2.getData().get(key) : ""));
            }
        }
        catch (IOException e) {
            this.difMap = null;
        }
    }

    private boolean canMapBeRetrieved(Data data) throws IOException {
        return data != null && data.getData() != null;
    }

    private boolean checkMapAttribute(Data data, String key) throws IOException {
        return this.canMapBeRetrieved(data) && data.getData().containsKey(key);
    }
}

