/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.data;

import hudson.model.AbstractBuild;
import hudson.model.Node;
import java.io.IOException;
import java.util.TreeMap;
import org.jenkinsci.plugins.buildenvironment.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveData
extends Data {
    public SlaveData(AbstractBuild<?, ?> build, String name, String id) {
        super(name, id);
        this.initializeDataMap(build.getBuiltOn());
    }

    private void initializeDataMap(Node node) {
        TreeMap<String, String> data = this.initEmptyMap();
        if (node == null) {
            data.put("Node was null", "build.getBuildOn() was null");
            return;
        }
        data.put("Node display name", node.getDisplayName());
        data.put("Number of executors", String.valueOf(node.getNumExecutors()));
        data.put("Node label", node.getLabelString());
        data.put("Node name", node.getNodeName());
        data.put("Node mode", node.getMode().toString());
        data.put("Node root path", node.getRootPath().toString());
        data.put("is Hold off launch until save", String.valueOf(node.isHoldOffLaunchUntilSave()));
        try {
            data.putAll(node.toComputer().getEnvVars());
            data.put("Busy executors", String.valueOf(node.toComputer().countBusy()));
            data.put("Host name", node.toComputer().getHostName());
            data.put("idle executors", String.valueOf(node.toComputer().countIdle()));
            data.put("Computer connect time", String.valueOf(node.toComputer().getConnectTime()));
            data.put("Demand start in ms", String.valueOf(node.toComputer().getDemandStartMilliseconds()));
            data.put("Computer Heap dump", node.toComputer().getHeapDump().toString());
            data.put("Computer retention strategy", node.toComputer().getRetentionStrategy().toString());
            for (Object obj : node.toComputer().getSystemProperties().keySet()) {
                data.put(obj.toString(), node.toComputer().getSystemProperties().get(obj).toString());
            }
            data.put("Is accepting tasks", String.valueOf(node.toComputer().isAcceptingTasks()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

