/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.data;

import hudson.model.AbstractBuild;
import hudson.model.Node;
import java.io.IOException;
import java.util.TreeMap;
import org.jenkinsci.plugins.buildenvironment.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveData
extends Data {
    public SlaveData(AbstractBuild<?, ?> build, String name, String id) {
        super(name, id);
        this.initializeDataMap(build.getBuiltOn());
    }

    private void initializeDataMap(Node node) {
        this.data = new TreeMap();
        if (node == null) {
            this.data.put("Node was null", "build.getBuildOn() was null");
            return;
        }
        this.data.put("Node display name", node.getDisplayName());
        this.data.put("Number of executors", String.valueOf(node.getNumExecutors()));
        this.data.put("Node label", node.getLabelString());
        this.data.put("Node name", node.getNodeName());
        this.data.put("Node mode", node.getMode().toString());
        this.data.put("Node root path", node.getRootPath().toString());
        this.data.put("is Hold off launch until save", String.valueOf(node.isHoldOffLaunchUntilSave()));
        try {
            this.data.putAll(node.toComputer().getEnvVars());
            this.data.put("Busy executors", String.valueOf(node.toComputer().countBusy()));
            this.data.put("Host name", node.toComputer().getHostName());
            this.data.put("idle executors", String.valueOf(node.toComputer().countIdle()));
            this.data.put("Computer connect time", String.valueOf(node.toComputer().getConnectTime()));
            this.data.put("Demand start in ms", String.valueOf(node.toComputer().getDemandStartMilliseconds()));
            this.data.put("Computer Heap dump", node.toComputer().getHeapDump().toString());
            this.data.put("Computer retention strategy", node.toComputer().getRetentionStrategy().toString());
            for (Object obj : node.toComputer().getSystemProperties().keySet()) {
                this.data.put(obj.toString(), node.toComputer().getSystemProperties().get(obj).toString());
            }
            this.data.put("Is accepting tasks", String.valueOf(node.toComputer().isAcceptingTasks()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

