/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.data;

import hudson.model.AbstractProject;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.TreeMap;
import org.jenkinsci.plugins.buildenvironment.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
extends Data {
    public ProjectData(AbstractProject<?, ?> project, String name, String id) {
        super(name, id);
        this.initializeDataMap(project);
    }

    private void initializeDataMap(AbstractProject<?, ?> project) {
        this.data = new TreeMap();
        this.data.put("Project name", project.getName());
        this.data.put("Project url", project.getUrl());
        this.data.put("SCM", project.getScm().toString());
        this.data.put("SCM type", project.getScm().getType());
        this.data.put("Quiet period", String.valueOf(project.getQuietPeriod()));
        this.data.put("Block when downstream building", String.valueOf(project.blockBuildWhenDownstreamBuilding()));
        this.data.put("Block when upstream building", String.valueOf(project.blockBuildWhenUpstreamBuilding()));
        this.data.put("Abort permission", String.valueOf(project.hasAbortPermission()));
        this.data.put("Is buildable", String.valueOf(project.isBuildable()));
        this.data.put("Is concurrent build", String.valueOf(project.isConcurrentBuild()));
        this.data.put("Is disabled", String.valueOf(project.isDisabled()));
        this.data.put("Is fingerprint configured", String.valueOf(project.isFingerprintConfigured()));
        this.data.put("Is parameterized", String.valueOf(project.isParameterized()));
        this.data.put("Is name editable", String.valueOf(project.isNameEditable()));
        for (TriggerDescriptor i : project.getTriggers().keySet()) {
            this.data.put(i.getDisplayName(), ((Trigger)project.getTriggers().get(i)).toString());
        }
    }
}

