/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.actions;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.RunList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.buildenvironment.actions.utils.Constants;
import org.jenkinsci.plugins.buildenvironment.actions.utils.Utils;
import org.jenkinsci.plugins.buildenvironment.data.Data;
import org.jenkinsci.plugins.buildenvironment.data.DataDifferenceObject;
import org.jenkinsci.plugins.buildenvironment.data.EnvVarsData;
import org.jenkinsci.plugins.buildenvironment.data.ProjectData;
import org.jenkinsci.plugins.buildenvironment.data.SlaveData;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEnvironmentBuildAction
extends Actionable
implements Action {
    private static final Logger LOGGER = Logger.getLogger(BuildEnvironmentBuildAction.class.getName());
    private final AbstractBuild<?, ?> build;
    private AbstractBuild<?, ?> build1;
    private AbstractBuild<?, ?> build2;
    private String diffOption;
    private List<Data> dataHolders;
    private List<DataDifferenceObject> dataDifference;

    public BuildEnvironmentBuildAction(Run<?, ?> build) {
        this.build = (AbstractBuild)build;
        this.build1 = this.build;
        this.build2 = this.build;
        this.diffOption = String.valueOf(false);
        this.addDataHolders();
    }

    public String getDisplayName() {
        return "Compare environment";
    }

    public String getIconFileName() {
        return "/plugin/build-environment/icons/menu_icon.png";
    }

    public String getSummaryIconFilename() {
        return "/plugin/build-environment/icons/summary_icon.png";
    }

    public String getUrlName() {
        return "compare_environment";
    }

    public String getSearchUrl() {
        return "compare_environment";
    }

    public List<Data> getDataHoldersList() {
        return this.dataHolders;
    }

    public String trueFalseToYesNo(boolean value) {
        if (value) {
            return "yes";
        }
        return "no";
    }

    public List<AbstractBuild<?, ?>> getBuildsWithAction() {
        ArrayList list = new ArrayList();
        AbstractBuild currentBuild = null;
        if (this.getProject().getLastCompletedBuild() instanceof AbstractBuild) {
            currentBuild = (AbstractBuild)this.getProject().getLastCompletedBuild();
        }
        while (currentBuild != null) {
            if (currentBuild.getAction(BuildEnvironmentBuildAction.class) != null) {
                list.add(currentBuild);
            }
            currentBuild = (AbstractBuild)currentBuild.getPreviousCompletedBuild();
        }
        return list;
    }

    public ArrayList<String> getEnvironmentVariablesForExport() {
        Data envVars = null;
        for (Data data : this.getDataHoldersList()) {
            if (!"envVars".equals(data.getId())) continue;
            envVars = data;
            break;
        }
        TreeMap<String, String> envVarsMap = envVars != null ? envVars.getData() : new TreeMap(this.getBuild().getEnvVars());
        ArrayList<String> exportVars = new ArrayList<String>();
        for (Map.Entry<String, String> element : envVarsMap.entrySet()) {
            exportVars.add(element.getKey() + "=" + element.getValue() + "\n");
            exportVars.add("export " + element.getKey() + "\n");
            LOGGER.info(element.getKey());
        }
        LOGGER.info(exportVars.size() + "");
        return exportVars;
    }

    public RunList<?> getBuilds() {
        return this.getProject().getBuilds();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Job<?, ?> getProject() {
        return this.build.getProject();
    }

    public AbstractProject<?, ?> getAbstractProject() {
        return (AbstractProject)this.build.getParent();
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        JSONObject form = req.getSubmittedForm();
        this.build1 = this.getAbstractProject().getBuildByNumber(Integer.parseInt(form.getString("build1")));
        this.build2 = this.getAbstractProject().getBuildByNumber(Integer.parseInt(form.getString("build2")));
        this.diffOption = form.getString("diffOnly");
        rsp.sendRedirect(this.getRedirectUrl());
    }

    public boolean isOnlyDifference() {
        return this.diffOption != null && this.diffOption.equals("true");
    }

    private String getRedirectUrl() {
        return this.getBuildUrl() + "/" + "compare_environment";
    }

    public AbstractBuild<?, ?> getBuild1() {
        return this.build1;
    }

    public AbstractBuild<?, ?> getBuild2() {
        return this.build2;
    }

    public String getBackgroundColor(boolean change) {
        if (change) {
            return Constants.getBackgroundDifferenceColorAsString();
        }
        return Constants.getBackgroundNoDifferenceColorAsString();
    }

    public int getDifferentCount(Data data) {
        if (this.dataDifference == null) {
            this.calculatePreviousBuildDifference();
        }
        try {
            return this.getDataDifferenceObjectByName(data.getName()).getDifferentCount();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public boolean isDifferentFromPrevious(Data data, String key) {
        if (this.dataDifference == null) {
            this.calculatePreviousBuildDifference();
        }
        try {
            return this.getDataDifferenceObjectByName(data.getName()).getMap().get(key).areDifferent();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public List<DataDifferenceObject> getDifference() {
        if (this.build1 == null || this.build2 == null) {
            return null;
        }
        return this.getDifference(this.build1, this.build2);
    }

    private DataDifferenceObject getDataDifferenceObjectByName(String name) {
        for (DataDifferenceObject currentDataDiff : this.dataDifference) {
            if (!currentDataDiff.getName().equals(name)) continue;
            return currentDataDiff;
        }
        return null;
    }

    private void calculatePreviousBuildDifference() {
        AbstractBuild previousBuild;
        for (previousBuild = (AbstractBuild)this.build.getPreviousCompletedBuild(); previousBuild != null && previousBuild.getAction(BuildEnvironmentBuildAction.class) == null; previousBuild = (AbstractBuild)previousBuild.getPreviousCompletedBuild()) {
        }
        this.dataDifference = previousBuild != null ? this.getDifference(this.build, previousBuild) : null;
    }

    private List<DataDifferenceObject> getDifference(AbstractBuild<?, ?> build1, AbstractBuild<?, ?> build2) {
        BuildEnvironmentBuildAction action1 = (BuildEnvironmentBuildAction)build1.getAction(BuildEnvironmentBuildAction.class);
        BuildEnvironmentBuildAction action2 = (BuildEnvironmentBuildAction)build2.getAction(BuildEnvironmentBuildAction.class);
        ArrayList<DataDifferenceObject> diffList = new ArrayList<DataDifferenceObject>();
        block0: for (Data data1 : action1.getDataHoldersList()) {
            for (Data data2 : action2.getDataHoldersList()) {
                if (!data1.getClass().getName().equals(data2.getClass().getName())) continue;
                diffList.add(new DataDifferenceObject(data1, data2));
                continue block0;
            }
        }
        return diffList;
    }

    private String getBuildUrl() {
        if (this.getProject() != null) {
            return this.getProject().getAbsoluteUrl() + this.getBuildNumber();
        }
        return this.build.getAbsoluteUrl();
    }

    private String getBuildNumber() {
        return Integer.toString(this.build.getNumber());
    }

    private void addDataHolders() {
        this.dataHolders = new ArrayList<Data>();
        this.dataHolders.add(new EnvVarsData(this.build, "Environment Variables", "envVar"));
        this.dataHolders.add(new SlaveData(this.build, "Slave Information", "slaveInfo"));
        this.dataHolders.add(new ProjectData(this.getAbstractProject(), "Project Information", "projectInfo"));
        for (Data data : this.dataHolders) {
            Utils.filterMap(data.getData(), this.build);
        }
    }
}

