/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildenvironment.data;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import java.util.TreeMap;
import org.jenkinsci.plugins.buildenvironment.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
extends Data {
    public ProjectData(AbstractProject<?, ?> project, AbstractBuild<?, ?> build, String name, String id) {
        super(project, build, name, id);
        this.initializeDataMap();
    }

    private void initializeDataMap() {
        this.data = new TreeMap();
        this.data.put("Project name", this.getProject().getName());
        this.data.put("Project url", this.getProject().getUrl());
        this.data.put("SCM", this.getProject().getScm().toString());
        this.data.put("SCM type", this.getProject().getScm().getType());
        this.data.put("Quiet period", String.valueOf(this.getProject().getQuietPeriod()));
        this.data.put("Block when downstream building", String.valueOf(this.getProject().blockBuildWhenDownstreamBuilding()));
        this.data.put("Block when upstream building", String.valueOf(this.getProject().blockBuildWhenUpstreamBuilding()));
        this.data.put("Abort permission", String.valueOf(this.getProject().hasAbortPermission()));
        this.data.put("Is buildable", String.valueOf(this.getProject().isBuildable()));
        this.data.put("Is concurrent build", String.valueOf(this.getProject().isConcurrentBuild()));
        this.data.put("Is disabled", String.valueOf(this.getProject().isDisabled()));
        this.data.put("Is fingerprint configured", String.valueOf(this.getProject().isFingerprintConfigured()));
        this.data.put("Is parameterized", String.valueOf(this.getProject().isParameterized()));
        this.data.put("Is name editable", String.valueOf(this.getProject().isNameEditable()));
        try {
            this.data.put("configFileMap", this.getProject().getConfigFile().asString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (TriggerDescriptor i : this.getProject().getTriggers().keySet()) {
            this.data.put(i.getDisplayName(), ((Trigger)this.getProject().getTriggers().get(i)).toString());
        }
    }
}

