/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import jenkins.branch.RewindableFileOutputStream;

class RewindableRotatingFileOutputStream
extends RewindableFileOutputStream {
    private final int size;

    public RewindableRotatingFileOutputStream(File out, int size) {
        super(out);
        this.size = size;
    }

    public RewindableRotatingFileOutputStream(File out, boolean initialAppend, int size) {
        super(out, initialAppend);
        this.size = size;
    }

    protected File getNumberedFileName(int n) {
        if (n == 0) {
            return this.out;
        }
        return new File(this.out.getPath() + "." + n);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void rewind() throws IOException {
        super.rewind();
        for (int i = this.size - 1; i >= 0; --i) {
            File fi = this.getNumberedFileName(i);
            if (!fi.exists()) continue;
            File next = this.getNumberedFileName(i + 1);
            next.delete();
            fi.renameTo(next);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void deleteAll() {
        for (int i = 0; i <= this.size; ++i) {
            this.getNumberedFileName(i).delete();
        }
    }
}

