/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.model.TransientActionFactory;

public class DeadBranchIndicatorAction
extends InvisibleAction {
    public String getDisabledColor() {
        return BallColor.DISABLED.getHtmlBaseColor();
    }

    @Extension
    public static class RunFactoryImpl
    extends TransientActionFactory<Run> {
        public Class<Run> type() {
            return Run.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull Run target) {
            Branch b;
            MultiBranchProject p;
            BranchProjectFactory factory;
            Job job = target.getParent();
            if (job.getParent() instanceof MultiBranchProject && (factory = (p = (MultiBranchProject)job.getParent()).getProjectFactory()).isProject((Item)job) && (b = factory.getBranch(factory.asProject((Item)job))) instanceof Branch.Dead) {
                return Collections.singleton(new DeadBranchIndicatorAction());
            }
            return Collections.emptyList();
        }
    }

    @Extension
    public static class JobFactoryImpl
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull Job job) {
            Branch b;
            MultiBranchProject p;
            BranchProjectFactory factory;
            if (job.getParent() instanceof MultiBranchProject && (factory = (p = (MultiBranchProject)job.getParent()).getProjectFactory()).isProject((Item)job) && (b = factory.getBranch(factory.asProject((Item)job))) instanceof Branch.Dead) {
                return Collections.singleton(new DeadBranchIndicatorAction());
            }
            return Collections.emptyList();
        }
    }
}

