/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchPropertyStrategyDescriptor;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BranchSource
extends AbstractDescribableImpl<BranchSource> {
    @NonNull
    private final SCMSource source;
    private BranchPropertyStrategy strategy;
    @CheckForNull
    private List<BranchBuildStrategy> buildStrategies;

    @DataBoundConstructor
    public BranchSource(SCMSource source) {
        this.source = source;
    }

    @Deprecated
    public BranchSource(SCMSource source, BranchPropertyStrategy strategy) {
        this.source = source;
        this.strategy = strategy;
    }

    private Object readResolve() {
        if (this.source == null) {
            throw new IllegalStateException("Unloadable SCM Source");
        }
        return this;
    }

    @Exported
    @NonNull
    public SCMSource getSource() {
        return this.source;
    }

    public BranchPropertyStrategy getStrategy() {
        return this.strategy != null ? this.strategy : new DefaultBranchPropertyStrategy(new BranchProperty[0]);
    }

    @DataBoundSetter
    public void setStrategy(BranchPropertyStrategy strategy) {
        this.strategy = strategy;
    }

    @NonNull
    public List<BranchBuildStrategy> getBuildStrategies() {
        return this.buildStrategies == null ? Collections.emptyList() : Collections.unmodifiableList(this.buildStrategies);
    }

    @DataBoundSetter
    public void setBuildStrategies(@CheckForNull List<BranchBuildStrategy> buildStrategies) {
        this.buildStrategies = buildStrategies == null || buildStrategies.isEmpty() ? null : new ArrayList<BranchBuildStrategy>(buildStrategies);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BranchSource> {
        public String getDisplayName() {
            return "Branch source";
        }

        public List<BranchPropertyStrategyDescriptor> propertyStrategyDescriptors(@NonNull MultiBranchProject project, @NonNull SCMSourceDescriptor sourceDescriptor) {
            return BranchPropertyStrategyDescriptor.all(project, sourceDescriptor);
        }

        public List<BranchBuildStrategyDescriptor> buildStrategiesDescriptors(@NonNull MultiBranchProject project, @NonNull SCMSourceDescriptor sourceDescriptor) {
            return BranchBuildStrategyDescriptor.all(project, sourceDescriptor);
        }
    }
}

