/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import java.util.ArrayList;
import java.util.List;
import jenkins.branch.BranchProperty;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public abstract class BranchPropertyDescriptor
extends Descriptor<BranchProperty> {
    public boolean isApplicable(@NonNull MultiBranchProject project) {
        return this.isApplicable(project.getDescriptor());
    }

    protected boolean isApplicable(@NonNull MultiBranchProjectDescriptor projectDescriptor) {
        return true;
    }

    public static List<BranchPropertyDescriptor> all() {
        return ExtensionList.lookup(BranchPropertyDescriptor.class);
    }

    public static List<BranchPropertyDescriptor> all(@NonNull MultiBranchProject project) {
        ArrayList<BranchPropertyDescriptor> result = new ArrayList<BranchPropertyDescriptor>();
        for (BranchPropertyDescriptor d : BranchPropertyDescriptor.all()) {
            if (!d.isApplicable(project)) continue;
            result.add(d);
        }
        return result;
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static final class Visibility
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (context instanceof MultiBranchProject && descriptor instanceof BranchPropertyDescriptor) {
                return ((BranchPropertyDescriptor)descriptor).isApplicable((MultiBranchProject)((Object)context));
            }
            return true;
        }
    }
}

