/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.NoTriggerMultiBranchQueueDecisionHandler;
import jenkins.branch.OrganizationFolder;
import jenkins.branch.PropertyMigration;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class NoTriggerOrganizationFolderProperty
extends AbstractFolderProperty<OrganizationFolder>
implements NoTriggerMultiBranchQueueDecisionHandler.NoTriggerProperty {
    private final String branches;
    private NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy strategy;

    @DataBoundConstructor
    public NoTriggerOrganizationFolderProperty(String branches) {
        this.branches = branches;
    }

    public String getBranches() {
        return this.branches;
    }

    @Override
    @NonNull
    public String getTriggeredBranchesRegex() {
        if (this.branches == null) {
            return ".*";
        }
        return this.branches;
    }

    @Override
    @NonNull
    public NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy getStrategy() {
        if (this.strategy == null) {
            return NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy.NONE;
        }
        return this.strategy;
    }

    @DataBoundSetter
    public void setStrategy(NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy strategy) {
        this.strategy = strategy;
    }

    @Extension
    public static class PropertyMigrationImpl
    extends PropertyMigration<OrganizationFolder, NoTriggerOrganizationFolderProperty> {
        public PropertyMigrationImpl() {
            super(OrganizationFolder.class, NoTriggerOrganizationFolderProperty.class, "basic-branch-build-strategies:1.1.0");
        }

        @Override
        public Localizable getDescription() {
            return Messages._NoTriggerOrganizationFolderProperty_PropertyMigrationWarning();
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    @Extension
    public static class Dispatcher
    extends NoTriggerMultiBranchQueueDecisionHandler {
        @Override
        @NonNull
        protected Iterable<? extends Object> getBranchProperties(MultiBranchProject project, Job job) {
            if (project.getParent() instanceof OrganizationFolder) {
                return ((OrganizationFolder)project.getParent()).getProperties();
            }
            return Collections.emptyList();
        }
    }

    @Extension
    @Symbol(value={"suppressFolderAutomaticTriggering"})
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.NoTriggerBranchProperty_suppress_automatic_scm_triggering();
        }

        public FormValidation doCheckBranches(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException x) {
                return FormValidation.error((String)x.getMessage());
            }
        }
    }
}

