/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.views.ViewJobFilter;
import java.util.List;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHeadCategory;

public class BranchCategoryFilter
extends ViewJobFilter {
    @NonNull
    private final SCMHeadCategory category;

    public BranchCategoryFilter(@NonNull SCMHeadCategory category) {
        this.category = category;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ViewGroup owner = filteringView.getOwner();
        if (owner instanceof MultiBranchProject) {
            MultiBranchProject project = (MultiBranchProject)owner;
            List categories = this.category.isUncategorized() ? SCMHeadCategory.collect(project.getSCMSources()) : null;
            BranchProjectFactory factory = project.getProjectFactory();
            for (TopLevelItem item : all) {
                if (added.contains(item) || !factory.isProject((Item)item) || !this.category.isMatch((Object)factory.getBranch(factory.asProject((Item)item)).getHead(), (Iterable)categories)) continue;
                added.add(item);
            }
        }
        return added;
    }
}

