/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchPropertyStrategyDescriptor;
import jenkins.branch.Messages;
import jenkins.scm.api.SCMHead;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class NamedExceptionsBranchPropertyStrategy
extends BranchPropertyStrategy {
    @NonNull
    private final List<BranchProperty> defaultProperties;
    @NonNull
    private final List<Named> namedExceptions;

    @DataBoundConstructor
    public NamedExceptionsBranchPropertyStrategy(@CheckForNull BranchProperty[] defaultProperties, @CheckForNull Named[] namedExceptions) {
        this.defaultProperties = defaultProperties == null ? Collections.emptyList() : Arrays.asList(defaultProperties);
        this.namedExceptions = namedExceptions == null ? Collections.emptyList() : Arrays.asList(namedExceptions);
    }

    @NonNull
    public List<BranchProperty> getDefaultProperties() {
        return this.defaultProperties;
    }

    @NonNull
    public List<Named> getNamedExceptions() {
        return this.namedExceptions;
    }

    @Override
    @NonNull
    public List<BranchProperty> getPropertiesFor(SCMHead head) {
        for (Named named : this.namedExceptions) {
            if (!named.isMatch(head)) continue;
            return new ArrayList<BranchProperty>(named.getProps());
        }
        return new ArrayList<BranchProperty>(this.defaultProperties);
    }

    public static class Named
    extends AbstractDescribableImpl<Named> {
        @NonNull
        private final List<BranchProperty> props;
        @NonNull
        private final String name;

        @DataBoundConstructor
        public Named(@CheckForNull String name, @CheckForNull BranchProperty[] props) {
            this.name = Util.fixNull((String)name);
            this.props = props == null ? Collections.emptyList() : Arrays.asList(props);
        }

        @NonNull
        public List<BranchProperty> getProps() {
            return this.props;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public boolean isMatch(@NonNull SCMHead head) {
            return Named.isMatch(head.getName(), this.name);
        }

        public static boolean isMatch(String branchName, String names) {
            for (String name : StringUtils.split((String)names, (String)",")) {
                boolean match;
                boolean invertMatch;
                if ((name = name.trim()).startsWith("!")) {
                    name = name.substring(1);
                    invertMatch = true;
                } else if (name.startsWith("\\!") || name.startsWith("\\\\!")) {
                    name = name.substring(1);
                    invertMatch = false;
                } else {
                    invertMatch = false;
                }
                if (name.indexOf(42) == -1 && name.indexOf(63) == -1) {
                    match = name.equalsIgnoreCase(branchName);
                } else {
                    name = name.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                    branchName = branchName.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                    match = SelectorUtils.matchPath((String)name, (String)branchName, (boolean)false);
                }
                if (!(invertMatch ? !match : match)) continue;
                return true;
            }
            return false;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Named> {
            @NonNull
            public String getDisplayName() {
                return "Named exception";
            }
        }
    }

    @Symbol(value={"namedBranchesDifferent"})
    @Extension
    public static class DescriptorImpl
    extends BranchPropertyStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.NamedExceptionsBranchPropertyStrategy_DisplayName();
        }
    }
}

