/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.Timer;

class Timeout
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(Timeout.class.getName());
    private final ScheduledFuture<?> task;

    private Timeout(ScheduledFuture<?> task) {
        this.task = task;
    }

    @Override
    public void close() {
        this.task.cancel(false);
    }

    public static Timeout limit(final long time, final TimeUnit unit) {
        final Thread thread = Thread.currentThread();
        return new Timeout(Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isLoggable(Level.FINE)) {
                    Throwable t = new Throwable();
                    t.setStackTrace(thread.getStackTrace());
                    LOGGER.log(Level.FINE, "Interrupting " + thread + " after " + time + " " + (Object)((Object)unit), t);
                }
                thread.interrupt();
            }
        }, time, unit));
    }
}

