/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyDescriptor;
import jenkins.branch.JobDecorator;
import jenkins.branch.Messages;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RateLimitBranchProperty
extends BranchProperty {
    private static final Logger LOGGER = Logger.getLogger(RateLimitBranchProperty.class.getName());
    private static final Map<String, Long> DURATIONS = RateLimitBranchProperty.createDurations();
    private final String durationName;
    private final int count;
    private final boolean userBoost;

    private static Map<String, Long> createDurations() {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        result.put("second", TimeUnit.SECONDS.toMillis(1L));
        result.put("minute", TimeUnit.MINUTES.toMillis(1L));
        result.put("hour", TimeUnit.HOURS.toMillis(1L));
        result.put("day", TimeUnit.DAYS.toMillis(1L));
        result.put("week", TimeUnit.DAYS.toMillis(7L));
        result.put("month", TimeUnit.DAYS.toMillis(31L));
        result.put("year", TimeUnit.DAYS.toMillis(365L));
        return Collections.unmodifiableMap(result);
    }

    @Deprecated
    public RateLimitBranchProperty(int count, String durationName) {
        this(count, durationName, false);
    }

    @DataBoundConstructor
    public RateLimitBranchProperty(int count, String durationName, boolean userBoost) {
        this.count = Math.min(Math.max(1, count), 1000);
        this.durationName = durationName == null || !DURATIONS.containsKey(durationName) ? "hour" : durationName;
        this.userBoost = userBoost;
    }

    public int getCount() {
        return this.count;
    }

    public String getDurationName() {
        return this.durationName;
    }

    public boolean isUserBoost() {
        return this.userBoost;
    }

    @Override
    public <P extends Job<P, B>, B extends Run<P, B>> JobDecorator<P, B> jobDecorator(Class<P> jobType) {
        return new JobDecorator<P, B>(){

            @Override
            @NonNull
            public List<JobProperty<? super P>> jobProperties(@NonNull List<JobProperty<? super P>> properties) {
                ArrayList result = BranchProperty.asArrayList(properties);
                result.add(new JobPropertyImpl(RateLimitBranchProperty.this.count == 0 ? null : new Throttle(RateLimitBranchProperty.this.count, RateLimitBranchProperty.this.durationName, RateLimitBranchProperty.this.userBoost)));
                return result;
            }
        };
    }

    @Extension
    public static class QueueTaskDispatcherImpl
    extends QueueTaskDispatcher {
        public CauseOfBlockage canRun(Queue.Item item) {
            Job job;
            JobPropertyImpl property;
            if (item.task instanceof Job && (property = (JobPropertyImpl)(job = (Job)item.task).getProperty(JobPropertyImpl.class)) != null) {
                long betweenBuilds;
                long timeSinceLastBuild;
                if (property.isUserBoost()) {
                    for (Cause cause : item.getCauses()) {
                        if (!(cause instanceof Cause.UserIdCause) && !(cause instanceof Cause.UserCause)) continue;
                        LOGGER.log(Level.FINER, "{0} has a rate limit of {1} builds per {2} but user submitted and boost enabled", new Object[]{job.getFullName(), property.getCount(), property.getDurationName()});
                        return null;
                    }
                }
                LOGGER.log(Level.FINER, "{0} has a rate limit of {1} builds per {2}", new Object[]{job.getFullName(), property.getCount(), property.getDurationName()});
                Run lastBuild = job.getLastBuild();
                if (lastBuild != null && (timeSinceLastBuild = System.currentTimeMillis() - lastBuild.getTimeInMillis()) < (betweenBuilds = property.getMillisecondsBetweenBuilds())) {
                    LOGGER.log(Level.FINE, "{0} will be delayed for another {1}ms as it is {2}ms since last build and ideal rate is {3}ms between builds", new Object[]{job.getFullName(), betweenBuilds - timeSinceLastBuild, timeSinceLastBuild, betweenBuilds});
                    return CauseOfBlockage.fromMessage((Localizable)Messages._RateLimitBranchProperty_BuildBlocked(new Date(lastBuild.getTimeInMillis() + betweenBuilds)));
                }
                List items = Jenkins.get().getQueue().getItems(item.task);
                if (items.size() == 1 && item == items.get(0)) {
                    return null;
                }
                for (Queue.Item i : items) {
                    if (i.getId() >= item.getId()) continue;
                    LOGGER.log(Level.FINE, "{0} with queue id {1} blocked by queue id {2} was first", new Object[]{job.getFullName(), item.getId(), i.getId()});
                    long betweenBuilds2 = property.getMillisecondsBetweenBuilds();
                    return CauseOfBlockage.fromMessage((Localizable)Messages._RateLimitBranchProperty_BuildBlocked(new Date(System.currentTimeMillis() + betweenBuilds2)));
                }
            }
            return null;
        }
    }

    public static class JobPropertyImpl
    extends JobProperty<Job<?, ?>> {
        private final String durationName;
        private final int count;
        private final boolean userBoost;
        private transient long duration;
        private transient Throttle throttle;

        @DataBoundConstructor
        public JobPropertyImpl(Throttle throttle) {
            this.throttle = throttle;
            this.count = throttle == null ? 0 : Math.min(Math.max(0, throttle.getCount()), 1000);
            this.durationName = throttle == null ? "hour" : throttle.getDurationName();
            this.userBoost = throttle == null ? true : throttle.isUserBoost();
        }

        public int getCount() {
            return this.count;
        }

        public String getDurationName() {
            return this.durationName;
        }

        public boolean isUserBoost() {
            return this.userBoost;
        }

        public long getDuration() {
            if (this.duration < 1L) {
                String durationName = this.getDurationName();
                this.duration = DURATIONS.containsKey(durationName) ? ((Long)DURATIONS.get(durationName)).longValue() : TimeUnit.HOURS.toMillis(1L);
            }
            return this.duration;
        }

        public Throttle getThrottle() {
            if (this.count == 0) {
                return null;
            }
            if (this.throttle == null) {
                this.throttle = new Throttle(this.count, this.durationName, this.userBoost);
            }
            return this.throttle;
        }

        public long getMillisecondsBetweenBuilds() {
            return this.getCount() == 0 ? 0L : this.getDuration() / (long)Math.max(1, this.getCount());
        }

        @Extension
        @Symbol(value={"rateLimitBuilds"})
        public static class DescriptorImpl
        extends JobPropertyDescriptor {
            public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                JobPropertyImpl prop = (JobPropertyImpl)super.newInstance(req, formData);
                return prop.getThrottle() != null ? prop : null;
            }

            public String getDisplayName() {
                return Messages.RateLimitBranchProperty_DisplayName();
            }

            public ListBoxModel doFillDurationNameItems() {
                ListBoxModel result = new ListBoxModel();
                for (String unit : DURATIONS.keySet()) {
                    result.add(ResourceBundleHolder.get(Messages.class).format("RateLimitBranchProperty.duration." + unit, new Object[0]), unit);
                }
                return result;
            }

            public FormValidation doCheckCount(@QueryParameter int value, @QueryParameter String durationName) {
                long duration;
                long l = duration = DURATIONS.containsKey(durationName) ? ((Long)DURATIONS.get(durationName)).longValue() : TimeUnit.HOURS.toMillis(1L);
                if (value == 0) {
                    return FormValidation.ok();
                }
                long interval = duration / (long)Math.max(1, value);
                if (interval < TimeUnit.SECONDS.toMillis(1L)) {
                    return FormValidation.ok();
                }
                if (interval < TimeUnit.MINUTES.toMillis(1L)) {
                    return FormValidation.ok((String)Messages.RateLimitBranchProperty_ApproxSecsBetweenBuilds(TimeUnit.MILLISECONDS.toSeconds(interval)));
                }
                if (interval < TimeUnit.HOURS.toMillis(2L)) {
                    return FormValidation.ok((String)Messages.RateLimitBranchProperty_ApproxMinsBetweenBuilds(TimeUnit.MILLISECONDS.toMinutes(interval)));
                }
                if (interval < TimeUnit.DAYS.toMillis(2L)) {
                    return FormValidation.ok((String)Messages.RateLimitBranchProperty_ApproxHoursBetweenBuilds(TimeUnit.MILLISECONDS.toHours(interval)));
                }
                if (interval < TimeUnit.DAYS.toMillis(14L)) {
                    return FormValidation.ok((String)Messages.RateLimitBranchProperty_ApproxDaysBetweenBuilds(TimeUnit.MILLISECONDS.toDays(interval)));
                }
                return FormValidation.ok((String)Messages.RateLimitBranchProperty_ApproxWeeksBetweenBuilds(TimeUnit.MILLISECONDS.toDays(interval) / 7L));
            }
        }
    }

    public static class Throttle {
        private final String durationName;
        private final int count;
        private final boolean userBoost;

        @DataBoundConstructor
        public Throttle(int count, String durationName, boolean userBoost) {
            this.count = Math.min(Math.max(0, count), 1000);
            this.durationName = durationName == null || !DURATIONS.containsKey(durationName) ? "hour" : durationName;
            this.userBoost = userBoost;
        }

        public int getCount() {
            return this.count;
        }

        public String getDurationName() {
            return this.durationName;
        }

        public boolean isUserBoost() {
            return this.userBoost;
        }
    }

    @Symbol(value={"rateLimit"})
    @Extension
    public static class DescriptorImpl
    extends BranchPropertyDescriptor {
        public String getDisplayName() {
            return Messages.RateLimitBranchProperty_DisplayName();
        }

        public ListBoxModel doFillDurationNameItems() {
            return ((JobPropertyImpl.DescriptorImpl)Jenkins.get().getDescriptorByType(JobPropertyImpl.DescriptorImpl.class)).doFillDurationNameItems();
        }

        public FormValidation doCheckCount(@QueryParameter int value, @QueryParameter String durationName) {
            return ((JobPropertyImpl.DescriptorImpl)Jenkins.get().getDescriptorByType(JobPropertyImpl.DescriptorImpl.class)).doCheckCount(value, durationName);
        }
    }
}

