/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.views.ViewJobFilter;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCategory;

public class MultiBranchCategoryFilter
extends ViewJobFilter {
    @NonNull
    private final SCMSourceCategory category;

    public MultiBranchCategoryFilter(SCMSourceCategory category) {
        this.category = category;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ViewGroup owner = filteringView.getOwner();
        if (owner instanceof OrganizationFolder) {
            List categories = this.category.isUncategorized() ? SCMSourceCategory.collect(((OrganizationFolder)owner).getNavigators()) : null;
            block0: for (TopLevelItem item : all) {
                if (added.contains(item) || !(item instanceof MultiBranchProject)) continue;
                for (SCMSource s : ((MultiBranchProject)item).getSCMSources()) {
                    if (!this.category.isMatch((Object)s, (Iterable)categories)) continue;
                    added.add(item);
                    continue block0;
                }
            }
        }
        return added;
    }
}

