/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.EventOutputStreams;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import com.google.common.collect.ImmutableSet;
import com.thoughtworks.xstream.XStreamException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.listeners.SaveableListener;
import hudson.scm.PollingResult;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.PersistedList;
import hudson.util.StreamTaskListener;
import hudson.util.XStream2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.branch.Branch;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchEventCause;
import jenkins.branch.BranchIndexingCause;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.Messages;
import jenkins.branch.MetadataActionFolderIcon;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.branch.MultiBranchProjectEmptyView;
import jenkins.branch.MultiBranchProjectViewHolder;
import jenkins.branch.NameEncoder;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.impl.NullSCMSource;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class MultiBranchProject<P extends Job<P, R>, R extends Run<P, R>>
extends ComputedFolder<P>
implements SCMSourceOwner,
IconSpec {
    private static final Logger LOGGER = Logger.getLogger(MultiBranchProject.class.getName());
    private PersistedList<BranchSource> sources = new BranchSourceList(this);
    private transient State state = new State(this);
    private transient NullSCMSource nullSCMSource;
    private BranchProjectFactory<P, R> factory;
    private transient String srcDigest;
    private transient String facDigest;
    private static final XStream2 SOURCE_ID_OMITTED_XSTREAM = new XStream2();
    private static final Set<Permission> SUPPRESSED_PERMISSIONS;

    protected MultiBranchProject(ItemGroup parent, String name) {
        super(parent, name);
        this.init2();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.init2();
        try {
            this.srcDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.sources));
        }
        catch (XStreamException e) {
            this.srcDigest = null;
        }
        BranchProjectFactory<Job, R> factory = this.getProjectFactory();
        try {
            this.facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(factory));
        }
        catch (XStreamException e) {
            this.facDigest = null;
        }
        if (this.state == null) {
            this.state = new State(this);
        }
        try {
            this.state.load();
        }
        catch (XStreamException | IOException e) {
            LOGGER.log(Level.WARNING, "Could not read persisted state, will be recovered on next index.", e);
            this.state.reset();
        }
        HashMap<String, SCMSource> sourceMap = new HashMap<String, SCMSource>();
        for (BranchSource source : this.sources) {
            SCMSource s = source.getSource();
            String id = s.getId();
            if (sourceMap.containsKey(id)) continue;
            sourceMap.put(id, s);
        }
        for (Job item : this.getItems()) {
            SCMHead oldHead;
            SCMHead newHead;
            Branch oldBranch;
            SCMSource source;
            if (!factory.isProject((Item)item) || (source = (SCMSource)sourceMap.get((oldBranch = factory.getBranch(item)).getSourceId())) == null || source instanceof NullSCMSource || (newHead = SCMHeadMigration.readResolveSCMHead((SCMSource)source, (SCMHead)(oldHead = oldBranch.getHead()))) == oldHead) continue;
            LOGGER.log(Level.INFO, "Job {0}: a plugin upgrade is requesting migration of branch from {1} to {2}", new Object[]{item.getFullName(), oldHead.getClass(), newHead.getClass()});
            try {
                Branch newBranch = new Branch(oldBranch.getSourceId(), newHead, oldBranch.getScm(), oldBranch.getProperties());
                newBranch.setActions(oldBranch.getActions());
                factory.setBranch(item, newBranch);
                SCMRevision revision = factory.getRevision(item);
                factory.setRevisionHash(item, SCMHeadMigration.readResolveSCMRevision((SCMSource)source, (SCMRevision)revision));
            }
            catch (IOException | RuntimeException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Job {0}: Could not complete migration of branch from type {1} to {2}. The side-effect of this is that the next index may trigger a rebuild of the job (after which the issue will be resolved)");
                lr.setThrown(e);
                lr.setParameters(new Object[]{item.getFullName(), oldHead.getClass(), newHead.getClass()});
                LOGGER.log(lr);
            }
        }
    }

    private synchronized void init2() {
        if (this.sources == null) {
            this.sources = new PersistedList((Saveable)this);
        }
        if (this.nullSCMSource == null) {
            this.nullSCMSource = new NullSCMSource();
        }
        this.nullSCMSource.setOwner((SCMSourceOwner)this);
        for (SCMSource source : this.getSCMSources()) {
            source.setOwner((SCMSourceOwner)this);
        }
        BranchProjectFactory<P, R> factory = this.getProjectFactory();
        factory.setOwner(this);
        if (!(this.getFolderViews() instanceof MultiBranchProjectViewHolder)) {
            this.resetFolderViews();
        }
        if (!(this.getIcon() instanceof MetadataActionFolderIcon)) {
            this.setIcon(this.newDefaultFolderIcon());
        }
    }

    protected AbstractFolderViewHolder newFolderViewHolder() {
        return new MultiBranchProjectViewHolder(this);
    }

    protected FolderIcon newDefaultFolderIcon() {
        return new MetadataActionFolderIcon();
    }

    public String getIconClassName() {
        String result;
        if (this.sources.size() == 1) {
            result = ((BranchSource)((Object)this.sources.get(0))).getSource().getDescriptor().getIconClassName();
        } else {
            result = null;
            for (int i = 0; i < this.sources.size(); ++i) {
                String iconClassName = ((BranchSource)((Object)this.sources.get(i))).getSource().getDescriptor().getIconClassName();
                if (i == 0) {
                    result = iconClassName;
                    continue;
                }
                if (StringUtils.equals((String)result, (String)iconClassName)) continue;
                result = null;
                break;
            }
        }
        return result != null ? result : this.getDescriptor().getIconClassName();
    }

    public String getPronoun() {
        TreeSet<String> result = new TreeSet<String>();
        for (BranchSource source : this.sources) {
            String pronoun = Util.fixEmptyAndTrim((String)source.getSource().getPronoun());
            if (pronoun == null) continue;
            result.add(pronoun);
        }
        return result.isEmpty() ? super.getPronoun() : StringUtils.join(result, (String)" / ");
    }

    @NonNull
    public synchronized BranchProjectFactory<P, R> getProjectFactory() {
        if (this.factory == null) {
            this.setProjectFactory(this.newProjectFactory());
        }
        return this.factory;
    }

    public final Class<P> getProjectClass() {
        return this.getDescriptor().getProjectClass();
    }

    public synchronized void setProjectFactory(BranchProjectFactory<P, R> projectFactory) {
        ((Object)projectFactory).getClass();
        if (this.factory == projectFactory) {
            return;
        }
        if (this.factory != null) {
            this.factory.setOwner(null);
        }
        this.factory = projectFactory;
        this.factory.setOwner(this);
    }

    @NonNull
    protected abstract BranchProjectFactory<P, R> newProjectFactory();

    @NonNull
    public List<BranchSource> getSources() {
        if (this.sources != null) {
            return this.sources.toList();
        }
        return Collections.emptyList();
    }

    @NonNull
    public PersistedList<BranchSource> getSourcesList() {
        return this.sources;
    }

    public void setSourcesList(List<BranchSource> sources) throws IOException {
        Set<String> newIds;
        if (this.sources.isEmpty() || sources.isEmpty()) {
            this.sources.replaceBy(sources);
            return;
        }
        Set<String> oldIds = this.sourceIds((List<BranchSource>)this.sources);
        if (oldIds.containsAll(newIds = this.sourceIds(sources)) || newIds.containsAll(oldIds)) {
            this.sources.replaceBy(sources);
            return;
        }
        HashMap<String, String> changedIds = new HashMap<String, String>();
        HashSet<String> additions = new HashSet<String>(newIds);
        additions.removeAll(oldIds);
        HashSet<String> removals = new HashSet<String>(oldIds);
        removals.removeAll(newIds);
        block0: for (BranchSource addition : sources) {
            String additionId = addition.getSource().getId();
            if (!additions.contains(additionId)) continue;
            for (BranchSource removal : this.sources) {
                String removalId = removal.getSource().getId();
                if (!removals.contains(removalId) || !this.equalButForId(removal.getSource(), addition.getSource())) continue;
                changedIds.put(removalId, additionId);
                removals.remove(removalId);
                additions.remove(additionId);
                continue block0;
            }
        }
        this.sources.replaceBy(sources);
        BranchProjectFactory<Job, R> factory = this.getProjectFactory();
        for (Job item : this.getItems()) {
            Branch oldBranch;
            if (!factory.isProject((Item)item) || !changedIds.containsKey((oldBranch = factory.getBranch(item)).getSourceId())) continue;
            Branch newBranch = new Branch((String)changedIds.get(oldBranch.getSourceId()), oldBranch.getHead(), oldBranch.getScm(), oldBranch.getProperties());
            newBranch.setActions(oldBranch.getActions());
            factory.setBranch(item, newBranch);
        }
    }

    private Set<String> sourceIds(List<BranchSource> sources) {
        HashSet<String> result = new HashSet<String>();
        for (BranchSource s : sources) {
            result.add(s.getSource().getId());
        }
        return result;
    }

    private boolean equalButForId(SCMSource a, SCMSource b) {
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        return SOURCE_ID_OMITTED_XSTREAM.toXML((Object)a).equals(SOURCE_ID_OMITTED_XSTREAM.toXML((Object)b));
    }

    @NonNull
    public List<SCMSource> getSCMSources() {
        ArrayList<SCMSource> result = new ArrayList<SCMSource>();
        if (this.sources != null) {
            for (BranchSource source : this.sources) {
                result.add(source.getSource());
            }
        }
        return result;
    }

    @CheckForNull
    public SCMSource getSCMSource(@CheckForNull String sourceId) {
        for (SCMSource source : this.getSCMSources()) {
            if (!source.getId().equals(sourceId)) continue;
            return source;
        }
        return this.nullSCMSource;
    }

    @CheckForNull
    public BranchPropertyStrategy getBranchPropertyStrategy(@NonNull SCMSource source) {
        for (BranchSource s : this.getSources()) {
            if (!s.getSource().equals((Object)source)) continue;
            return s.getStrategy();
        }
        return null;
    }

    @NonNull
    private Branch newBranch(@NonNull SCMSource source, @NonNull SCMHead head) {
        source.getClass();
        head.getClass();
        String sourceId = source.getId();
        if (NullSCMSource.ID.equals(sourceId)) {
            return new Branch.Dead(head, Collections.emptyList());
        }
        BranchPropertyStrategy strategy = this.getBranchPropertyStrategy(source);
        return new Branch(sourceId, head, source.build(head), strategy != null ? strategy.getPropertiesFor(head) : Collections.emptyList());
    }

    @CheckForNull
    public SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource source) {
        return null;
    }

    public void onSCMSourceUpdated(@NonNull SCMSource source) {
        this.scheduleBuild(0, new BranchIndexingCause());
    }

    public boolean isHasEvents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void computeChildren(ChildObserver<P> observer, TaskListener listener) throws IOException, InterruptedException {
        block22: {
            try {
                this.srcDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.sources));
            }
            catch (XStreamException e) {
                this.srcDigest = null;
            }
            try {
                this.facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.getProjectFactory()));
            }
            catch (XStreamException e) {
                this.facDigest = null;
            }
            start = System.currentTimeMillis();
            listener.getLogger().format("[%tc] Starting branch indexing...%n", new Object[]{start});
            try {
                _factory = this.getProjectFactory();
                scmSources = this.getSCMSources();
                sourceActions = new LinkedHashMap<String, List>();
                for (SCMSource var9_13 : scmSources) {
                    try {
                        sourceActions.put(var9_13.getId(), var9_13.fetchActions(null, listener));
                    }
                    catch (IOException | InterruptedException | RuntimeException e) {
                        e.printStackTrace(listener.error("[%tc] Could not update folder level actions from source %s", new Object[]{System.currentTimeMillis(), var9_13.getId()}));
                        throw e;
                    }
                }
                if (sourceActions.equals(State.access$100(this.state))) ** GOTO lbl55
                saveProject = false;
                var9_14 = sourceActions.values().iterator();
                while (true) {
                    block23: {
                        if (var9_14.hasNext()) {
                            actions = (List)var9_14.next();
                            var11_24 = actions.iterator();
                            break block22;
                        }
                        var9_15 = new BulkChange((Saveable)this.state);
                        try {
                            State.access$100(this.state).keySet().retainAll(sourceActions.keySet());
                            State.access$100(this.state).putAll(sourceActions);
                            try {
                                var9_15.commit();
                            }
                            catch (IOException | RuntimeException e) {
                                e.printStackTrace(listener.error("[%tc] Could not persist folder level actions", new Object[]{System.currentTimeMillis()}));
                                throw e;
                            }
                            if (!saveProject) break block23;
                            try {
                                this.save();
                            }
                            catch (IOException | RuntimeException e) {
                                e.printStackTrace(listener.error("[%tc] Could not persist folder level configuration changes", new Object[]{System.currentTimeMillis()}));
                                throw e;
                            }
                        }
                        finally {
                            var9_15.abort();
                        }
                    }
                    for (SCMSource var9_18 : scmSources) {
                        try {
                            var9_18.fetch((SCMHeadObserver)new SCMHeadObserverImpl(var9_18, observer, listener, _factory, new IndexingCauseFactory(), null), listener);
                        }
                        catch (IOException | InterruptedException | RuntimeException e) {
                            e.printStackTrace(listener.error("[%tc] Could not fetch branches from source %s", new Object[]{System.currentTimeMillis(), var9_18.getId()}));
                            throw e;
                        }
                    }
                    break;
                }
            }
            catch (Throwable var14_27) {
                end = System.currentTimeMillis();
                listener.getLogger().format("[%tc] Finished branch indexing. Indexing took %s%n", new Object[]{end, Util.getTimeSpanString((long)(end - start))});
                throw var14_27;
            }
            {
                end = System.currentTimeMillis();
                listener.getLogger().format("[%tc] Finished branch indexing. Indexing took %s%n", new Object[]{end, Util.getTimeSpanString((long)(end - start))});
                return;
            }
        }
        while (true) {
            if (!var11_24.hasNext()) ** continue;
            a = (Action)var11_24.next();
            saveProject = this.removeActions(a.getClass()) != false || saveProject != false;
        }
    }

    private void scheduleBuild(BranchProjectFactory<P, R> factory, P item, SCMRevision revision, TaskListener listener, String name, Cause[] cause, Action ... actions) {
        Action[] _actions = new Action[actions.length + 1];
        _actions[0] = new CauseAction(cause);
        System.arraycopy(actions, 0, _actions, 1, actions.length);
        if (ParameterizedJobMixIn.scheduleBuild2(item, (int)0, (Action[])_actions) != null) {
            listener.getLogger().println("Scheduled build for branch: " + name);
            try {
                factory.setRevisionHash(item, revision);
            }
            catch (IOException e) {
                e.printStackTrace(listener.error("Could not update last revision hash"));
            }
        } else {
            listener.getLogger().println("Did not schedule build for branch: " + name);
        }
    }

    protected Collection<P> orphanedItems(Collection<P> orphaned, TaskListener listener) throws IOException, InterruptedException {
        BranchProjectFactory<Job, R> _factory = this.getProjectFactory();
        for (Job project : orphaned) {
            if (!_factory.isProject((Item)project)) {
                listener.getLogger().println("Detected unsupported subitem " + project + ", skipping");
                continue;
            }
            Branch b = _factory.getBranch(project);
            if (b instanceof Branch.Dead) continue;
            _factory.decorate(_factory.setBranch(project, new Branch.Dead(b)));
        }
        return super.orphanedItems(orphaned, listener);
    }

    @CheckForNull
    public P getItem(String name) {
        String decoded;
        if (name == null) {
            return null;
        }
        Job item = (Job)super.getItem(name);
        if (item != null) {
            return (P)item;
        }
        if (name.indexOf(37) != -1 && (item = (Job)super.getItem(decoded = NameEncoder.decode(name))) != null) {
            return (P)item;
        }
        return (P)((Job)super.getItem(NameEncoder.encode(name)));
    }

    @CheckForNull
    public P getItemByBranchName(@NonNull String branchName) {
        return (P)((Job)super.getItem(NameEncoder.encode(branchName)));
    }

    @Deprecated
    @CheckForNull
    public P getBranch(String name) {
        return this.getItem(name);
    }

    public ACL getACL() {
        final ACL acl = super.getACL();
        if (this.getParent() instanceof OrganizationFolder) {
            return new ACL(){

                public boolean hasPermission(Authentication a, Permission permission) {
                    if (ACL.SYSTEM.equals(a)) {
                        return true;
                    }
                    if (SUPPRESSED_PERMISSIONS.contains(permission)) {
                        return false;
                    }
                    return acl.hasPermission(a, permission);
                }
            };
        }
        return acl;
    }

    public String getDescription() {
        String description = super.getDescription();
        if (StringUtils.isNotBlank((String)description)) {
            return description;
        }
        ObjectMetadataAction action = (ObjectMetadataAction)this.getAction(ObjectMetadataAction.class);
        if (action != null) {
            return action.getObjectDescription();
        }
        return super.getDescription();
    }

    public String getDisplayName() {
        ObjectMetadataAction action;
        String displayName = this.getDisplayNameOrNull();
        if (displayName == null && (action = (ObjectMetadataAction)this.getAction(ObjectMetadataAction.class)) != null && StringUtils.isNotBlank((String)action.getObjectDisplayName())) {
            return action.getObjectDisplayName();
        }
        return super.getDisplayName();
    }

    @NonNull
    public File getJobsDir() {
        return new File(this.getRootDir(), "branches");
    }

    public File getRootDirFor(P child) {
        return super.getRootDirFor((TopLevelItem)child);
    }

    @NonNull
    public File getComputationDir() {
        return new File(this.getRootDir(), "indexing");
    }

    @NonNull
    public MultiBranchProjectDescriptor getDescriptor() {
        return (MultiBranchProjectDescriptor)super.getDescriptor();
    }

    public synchronized BranchIndexing<P, R> getIndexing() {
        return (BranchIndexing)this.getComputation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        String facDigest;
        String srcDigest;
        super.submit(req, rsp);
        ArrayList<SCMSource> _sources = new ArrayList<SCMSource>();
        MultiBranchProject multiBranchProject = this;
        synchronized (multiBranchProject) {
            JSONObject json = req.getSubmittedForm();
            this.setSourcesList(req.bindJSONToList(BranchSource.class, json.opt("sources")));
            for (SCMSource scmSource : this.getSCMSources()) {
                scmSource.setOwner((SCMSourceOwner)this);
                _sources.add(scmSource);
            }
            this.setProjectFactory((BranchProjectFactory)((Object)req.bindJSON(BranchProjectFactory.class, json.getJSONObject("projectFactory"))));
        }
        for (SCMSource scmSource : _sources) {
            scmSource.afterSave();
        }
        try {
            srcDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.sources));
        }
        catch (XStreamException e) {
            srcDigest = null;
        }
        try {
            facDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML(this.getProjectFactory()));
        }
        catch (XStreamException e) {
            facDigest = null;
        }
        this.recalculateAfterSubmitted(!StringUtils.equals((String)srcDigest, (String)this.srcDigest));
        this.recalculateAfterSubmitted(!StringUtils.equals((String)facDigest, (String)this.facDigest));
        this.srcDigest = srcDigest;
        this.facDigest = facDigest;
    }

    protected View getWelcomeView() {
        return new MultiBranchProjectEmptyView((ViewGroup)this);
    }

    public View getView(String name) {
        if (name.equals("Welcome")) {
            return this.getWelcomeView();
        }
        return super.getView(name);
    }

    public boolean isBuildable() {
        if (this.sources == null) {
            return false;
        }
        return !this.sources.isEmpty();
    }

    protected FolderComputation<P> createComputation(FolderComputation<P> previous) {
        return new BranchIndexing(this, (BranchIndexing)previous);
    }

    @NonNull
    public static String rawDecode(@NonNull String s) {
        byte[] bytes;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JLS specification mandates UTF-8 as a supported encoding", e);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37 && i + 2 < bytes.length) {
                int u = Character.digit((char)bytes[++i], 16);
                int l = Character.digit((char)bytes[++i], 16);
                if (u != -1 && l != -1) {
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                i -= 2;
            }
            buffer.write(b);
        }
        try {
            return new String(buffer.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JLS specification mandates UTF-8 as a supported encoding", e);
        }
    }

    private boolean isAutomaticBuild(SCMSource source, SCMHead head) {
        BranchSource branchSource = null;
        for (BranchSource s : this.sources) {
            if (!s.getSource().getId().equals(source.getId())) continue;
            branchSource = s;
            break;
        }
        if (branchSource == null) {
            return false;
        }
        List<BranchBuildStrategy> buildStrategies = branchSource.getBuildStrategies();
        if (buildStrategies.isEmpty()) {
            return !(head instanceof TagSCMHead);
        }
        for (BranchBuildStrategy s : buildStrategies) {
            if (!s.isAutomaticBuild(source, head)) continue;
            return true;
        }
        return false;
    }

    static {
        SOURCE_ID_OMITTED_XSTREAM.omitField(SCMSource.class, "id");
        SUPPRESSED_PERMISSIONS = ImmutableSet.of((Object)Item.CONFIGURE, (Object)Item.DELETE, (Object)View.CONFIGURE, (Object)View.CREATE, (Object)View.DELETE);
    }

    private static class State
    implements Saveable {
        @NonNull
        private final transient MultiBranchProject<?, ?> owner;
        private final Map<String, List<Action>> sourceActions = new HashMap<String, List<Action>>();

        private State(@NonNull MultiBranchProject<?, ?> owner) {
            this.owner = owner;
        }

        public synchronized void reset() {
            this.sourceActions.clear();
        }

        public synchronized void load() throws IOException {
            if (this.getStateFile().exists()) {
                this.getStateFile().unmarshal((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws IOException {
            State state = this;
            synchronized (state) {
                if (BulkChange.contains((Saveable)this)) {
                    return;
                }
                this.getStateFile().write((Object)this);
            }
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getStateFile());
        }

        public final XmlFile getStateFile() {
            return new XmlFile(Items.XSTREAM, new File(this.owner.getRootDir(), "state.xml"));
        }
    }

    @Extension
    public static class StateActionFactory
    extends TransientActionFactory<MultiBranchProject> {
        public Class<MultiBranchProject> type() {
            return MultiBranchProject.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull MultiBranchProject target) {
            ArrayList result = new ArrayList();
            MultiBranchProject project = target;
            for (BranchSource b : project.getSources()) {
                List actions = (List)project.state.sourceActions.get(b.getSource().getId());
                if (actions == null || actions.isEmpty()) continue;
                result.addAll(actions);
            }
            return result;
        }
    }

    private class SCMHeadObserverImpl
    extends SCMHeadObserver {
        @NonNull
        private final SCMSource source;
        @NonNull
        private final ChildObserver<P> observer;
        @NonNull
        private final TaskListener listener;
        @NonNull
        private final BranchProjectFactory<P, R> _factory;
        @NonNull
        private final CauseFactory causeFactory;
        @CheckForNull
        private final SCMHeadEvent<?> event;

        public SCMHeadObserverImpl(@NonNull SCMSource source, @NonNull ChildObserver<P> observer, @NonNull TaskListener listener, @NonNull BranchProjectFactory<P, R> _factory, @CheckForNull CauseFactory causeFactory, SCMHeadEvent<?> event) {
            this.source = source;
            this.observer = observer;
            this.listener = listener;
            this._factory = _factory;
            this.causeFactory = causeFactory;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            Branch origBranch;
            Branch branch = MultiBranchProject.this.newBranch(this.source, head);
            String rawName = branch.getName();
            String encodedName = branch.getEncodedName();
            Object project = (Job)this.observer.shouldUpdate(encodedName);
            if (project == null) {
                origBranch = null;
            } else {
                if (!this._factory.isProject((Item)project)) {
                    this.listener.getLogger().println("Detected unsupported subitem " + ModelHyperlinkNote.encodeTo((Item)project) + ", skipping");
                    return;
                }
                origBranch = this._factory.getBranch((Job)project);
                if (!(origBranch instanceof Branch.Dead) && !this.source.getId().equals(origBranch.getSourceId())) {
                    int ourPriority = Integer.MAX_VALUE;
                    int oldPriority = Integer.MAX_VALUE;
                    int p = 1;
                    for (BranchSource s : MultiBranchProject.this.sources) {
                        String sId = s.getSource().getId();
                        if (sId.equals(this.source.getId())) {
                            ourPriority = p;
                        }
                        if (sId.equals(origBranch.getSourceId())) {
                            oldPriority = p;
                        }
                        ++p;
                    }
                    if (oldPriority < ourPriority) {
                        this.listener.getLogger().println("Ignoring " + ModelHyperlinkNote.encodeTo((Item)project) + " from source #" + ourPriority + " as source #" + oldPriority + " owns the branch name");
                        return;
                    }
                    if (oldPriority == Integer.MAX_VALUE) {
                        this.listener.getLogger().println("Takeover for " + ModelHyperlinkNote.encodeTo((Item)project) + " by source #" + ourPriority + " from source that no longer exists");
                    } else {
                        this.listener.getLogger().println("Takeover for " + ModelHyperlinkNote.encodeTo((Item)project) + " by source #" + ourPriority + " from source #" + oldPriority);
                    }
                }
            }
            Action[] revisionActions = new Action[]{};
            boolean headActionsFetched = false;
            try {
                branch.setActions(this.source.fetchActions(head, this.event, this.listener));
                headActionsFetched = true;
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(this.listener.error("Could not fetch metadata of branch %s", new Object[]{rawName}));
            }
            try {
                List actions = this.source.fetchActions(revision, this.event, this.listener);
                revisionActions = actions.toArray(new Action[actions.size()]);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(this.listener.error("Could not fetch metadata for revision %s of branch %s", new Object[]{revision, rawName}));
            }
            if (project != null) {
                boolean rebuild;
                boolean bl = rebuild = origBranch instanceof Branch.Dead && !(branch instanceof Branch.Dead) || !this.source.getId().equals(origBranch.getSourceId());
                if (!headActionsFetched) {
                    branch.setActions(origBranch.getActions());
                }
                boolean needSave = !branch.equals(origBranch) || !branch.getActions().equals(origBranch.getActions());
                this._factory.decorate(this._factory.setBranch((Job)project, branch));
                if (rebuild) {
                    this.listener.getLogger().format("%s reopened: %s (%s)%n", StringUtils.defaultIfEmpty((String)head.getPronoun(), (String)"Branch"), rawName, revision);
                    needSave = true;
                    if (MultiBranchProject.this.isAutomaticBuild(this.source, head)) {
                        MultiBranchProject.this.scheduleBuild(this._factory, project, revision, this.listener, rawName, this.causeFactory.create(), revisionActions);
                    } else {
                        this.listener.getLogger().format("No automatic builds for %s%n", rawName);
                    }
                } else if (revision.isDeterministic()) {
                    SCMRevision lastBuild = this._factory.getRevision((Job)project);
                    if (!revision.equals((Object)lastBuild)) {
                        this.listener.getLogger().format("Changes detected: %s (%s \u2192 %s)%n", rawName, lastBuild, revision);
                        needSave = true;
                        if (MultiBranchProject.this.isAutomaticBuild(this.source, head)) {
                            MultiBranchProject.this.scheduleBuild(this._factory, project, revision, this.listener, rawName, this.causeFactory.create(), revisionActions);
                        } else {
                            this.listener.getLogger().format("No automatic builds for %s%n", rawName);
                        }
                    } else {
                        this.listener.getLogger().format("No changes detected: %s (still at %s)%n", rawName, revision);
                    }
                } else {
                    SCMTriggerItem scmProject = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                    if (scmProject != null) {
                        PollingResult pollingResult = scmProject.poll(this.listener);
                        if (pollingResult.hasChanges()) {
                            this.listener.getLogger().format("Changes detected: %s%n", rawName);
                            needSave = true;
                            if (MultiBranchProject.this.isAutomaticBuild(this.source, head)) {
                                MultiBranchProject.this.scheduleBuild(this._factory, project, revision, this.listener, rawName, this.causeFactory.create(), revisionActions);
                            } else {
                                this.listener.getLogger().format("No automatic builds for %s%n", rawName);
                            }
                        } else {
                            this.listener.getLogger().format("No changes detected: %s%n", rawName);
                        }
                    }
                }
                try {
                    if (needSave) {
                        project.save();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(this.listener.error("Could not save changes to " + rawName));
                }
                return;
            }
            if (!this.observer.mayCreate(encodedName)) {
                this.listener.getLogger().println("Ignoring duplicate branch project " + rawName);
                return;
            }
            ChildNameGenerator.Trace trace = ChildNameGenerator.beforeCreateItem((AbstractFolder)MultiBranchProject.this, (String)branch.getEncodedName(), (String)branch.getName());
            Object object = null;
            try {
                project = this._factory.newInstance(branch);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (trace != null) {
                    if (object != null) {
                        try {
                            trace.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        trace.close();
                    }
                }
            }
            if (!project.getName().equals(encodedName)) {
                throw new IllegalStateException("Name of created project " + project + " did not match expected " + encodedName);
            }
            BulkChange bc = new BulkChange((Saveable)project);
            try {
                if (project.getDisplayNameOrNull() == null && !rawName.equals(encodedName)) {
                    project.setDisplayName(rawName);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                bc.abort();
            }
            this._factory.decorate((Job)project);
            this.observer.created((TopLevelItem)project);
            if (MultiBranchProject.this.isAutomaticBuild(this.source, head)) {
                MultiBranchProject.this.scheduleBuild(this._factory, project, revision, this.listener, rawName, this.causeFactory.create(), revisionActions);
            } else {
                this.listener.getLogger().format("No automatic builds for %s%n", rawName);
            }
        }
    }

    private static class EventCauseFactory
    extends CauseFactory {
        @NonNull
        private final SCMHeadEvent<?> event;

        EventCauseFactory(SCMHeadEvent<?> event) {
            this.event = event;
        }

        @Override
        @NonNull
        Cause[] create() {
            Cause[] eventCauses = this.event.asCauses();
            Cause[] result = new Cause[eventCauses.length + 1];
            result[0] = new BranchEventCause((SCMEvent<?>)this.event);
            if (eventCauses.length > 0) {
                System.arraycopy(eventCauses, 0, result, 1, eventCauses.length);
            }
            return result;
        }
    }

    private static class IndexingCauseFactory
    extends CauseFactory {
        private IndexingCauseFactory() {
        }

        @Override
        @NonNull
        Cause[] create() {
            return new Cause[]{new BranchIndexingCause()};
        }
    }

    private static abstract class CauseFactory {
        private CauseFactory() {
        }

        @NonNull
        abstract Cause[] create();
    }

    @Extension
    public static class SCMEventListenerImpl
    extends SCMEventListener {
        private final EventOutputStreams globalEvents = this.createGlobalEvents();

        private EventOutputStreams createGlobalEvents() {
            File oldFile;
            File eventsFile;
            File logsDir = new File(Jenkins.getActiveInstance().getRootDir(), "logs");
            if (!logsDir.isDirectory() && !logsDir.mkdirs()) {
                LOGGER.log(Level.WARNING, "Could not create logs directory: {0}", logsDir);
            }
            if (!(eventsFile = new File(logsDir, MultiBranchProject.class.getName() + ".log")).isFile() && (oldFile = new File(logsDir.getParent(), eventsFile.getName())).isFile() && !oldFile.renameTo(eventsFile)) {
                FileUtils.deleteQuietly((File)oldFile);
            }
            return new EventOutputStreams(new EventOutputStreams.OutputFile(){

                @NonNull
                public File get() {
                    return eventsFile;
                }
            }, 250L, TimeUnit.MILLISECONDS, 1024, true, 32768L, 5);
        }

        @Restricted(value={NoExternalUse.class})
        public StreamTaskListener globalEventsListener() {
            return new StreamBuildListener(this.globalEvents.get(), Charsets.UTF_8);
        }

        public void onSCMHeadEvent(SCMHeadEvent<?> event) {
            try (StreamTaskListener global = this.globalEventsListener();){
                String eventClass = event.getClass().getName();
                String eventType = event.getType().name();
                String eventOrigin = event.getOrigin();
                long eventTimestamp = event.getTimestamp();
                global.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", System.currentTimeMillis(), eventClass, eventType, eventOrigin, eventTimestamp);
                LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: onSCMHeadEvent", new Object[]{eventClass, eventType, eventTimestamp});
                int matchCount = 0;
                try {
                    if (SCMEvent.Type.CREATED == event.getType()) {
                        matchCount = this.processHeadCreate(event, (TaskListener)global, eventClass, eventType, eventOrigin, eventTimestamp, matchCount);
                    } else if (SCMEvent.Type.UPDATED == event.getType() || SCMEvent.Type.REMOVED == event.getType()) {
                        matchCount = this.processHeadUpdate(event, (TaskListener)global, eventClass, eventType, eventOrigin, eventTimestamp, matchCount);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace(global.error("[%tc] Interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), eventClass, eventType, eventOrigin, eventTimestamp}));
                }
                global.getLogger().format("[%tc] Finished processing %s %s event from %s with timestamp %tc. Matched %d.%n", System.currentTimeMillis(), eventClass, eventType, eventOrigin, eventTimestamp, matchCount);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not close global event log file", e);
            }
        }

        /*
         * Loose catch block
         */
        private int processHeadCreate(SCMHeadEvent<?> event, TaskListener global, String eventClass, String eventType, String eventOrigin, long eventTimestamp, int matchCount) throws IOException, InterruptedException {
            HashSet<String> sourceIds = new HashSet<String>();
            for (MultiBranchProject p : Jenkins.getActiveInstance().getAllItems(MultiBranchProject.class)) {
                sourceIds.clear();
                String pFullName = p.getFullName();
                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Checking {3} for a match", new Object[]{eventClass, eventType, eventTimestamp, pFullName});
                boolean haveMatch = false;
                BranchProjectFactory _factory = p.getProjectFactory();
                block19: for (SCMSource source : p.getSCMSources()) {
                    if (event.isMatch(source)) {
                        LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Matches source {4}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId()});
                        for (SCMHead h : event.heads(source).keySet()) {
                            String name = h.getName();
                            Object job = p.getItemByBranchName(name);
                            if (job == null) {
                                LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Match: {5}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId(), name});
                                haveMatch = true;
                                ++matchCount;
                                global.getLogger().format("Found match against %s (new branch %s)%n", pFullName, name);
                                break block19;
                            }
                            Branch branch = _factory.getBranch(job);
                            if (branch instanceof Branch.Dead) {
                                LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Match: {5}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId(), name});
                                haveMatch = true;
                                ++matchCount;
                                global.getLogger().format("Found match against %s (resurrect branch %s)%n", pFullName, name);
                                break block19;
                            }
                            String sourceId = branch.getSourceId();
                            if (StringUtils.equals((String)sourceId, (String)source.getId())) {
                                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Already have: {5}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId(), name});
                                continue;
                            }
                            if (sourceIds.contains(sourceId)) {
                                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Ignored as already have {5} from higher priority source {6}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId(), name, sourceId});
                                continue;
                            }
                            LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: Source {4}: Match: {5} overriding lower priority source {6}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId(), name, sourceId});
                            haveMatch = true;
                            ++matchCount;
                            global.getLogger().format("Found match against %s (takeover branch %s)%n", pFullName, name);
                            break block19;
                        }
                        LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Project {3}: No new projects for {4}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId()});
                    } else {
                        LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Project {3}: Does not matches source {4}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, source.getId()});
                    }
                    sourceIds.add(source.getId());
                }
                if (!haveMatch) continue;
                long start = System.currentTimeMillis();
                try {
                    StreamTaskListener listener = p.getComputation().createEventsListener();
                    Throwable throwable = null;
                    try {
                        long end;
                        try {
                            listener.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", start, eventClass, eventType, eventOrigin, eventTimestamp);
                            ChildObserver childObserver = p.createEventsChildObserver();
                            for (SCMSource source : p.getSCMSources()) {
                                if (!event.isMatch(source)) continue;
                                SCMSourceCriteria sCMSourceCriteria = p.getSCMSourceCriteria(source);
                                MultiBranchProject multiBranchProject = p;
                                ((Object)((Object)multiBranchProject)).getClass();
                                source.fetch(sCMSourceCriteria, (SCMHeadObserver)multiBranchProject.new SCMHeadObserverImpl(source, childObserver, (TaskListener)listener, _factory, new EventCauseFactory(event), event), event, (TaskListener)listener);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error(e.getMessage()));
                            end = System.currentTimeMillis();
                            listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                            continue;
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace(listener.error(e2.getMessage()));
                            throw e2;
                            {
                                catch (Throwable throwable2) {
                                    long end2 = System.currentTimeMillis();
                                    listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end2, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end2 - start)));
                                    throw throwable2;
                                }
                            }
                        }
                        end = System.currentTimeMillis();
                        listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (listener == null) continue;
                        if (throwable != null) {
                            try {
                                listener.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        listener.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventClass, eventType, eventOrigin, eventTimestamp}));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventClass, eventType, eventOrigin, eventTimestamp}));
                    throw e;
                }
            }
            return matchCount;
        }

        /*
         * Could not resolve type clashes
         * Loose catch block
         */
        private int processHeadUpdate(SCMHeadEvent<?> event, TaskListener global, String eventClass, String eventType, String eventOrigin, long eventTimestamp, int matchCount) throws InterruptedException {
            IdentityHashMap<Object, SCMHead> matches = new IdentityHashMap<Object, SCMHead>();
            HashSet<String> candidateNames = new HashSet<String>();
            IdentityHashMap<SCMSource, Map> revisionMaps = new IdentityHashMap<SCMSource, Map>();
            HashSet<Object> jobs = new HashSet<Object>();
            for (MultiBranchProject p : Jenkins.getActiveInstance().getAllItems(MultiBranchProject.class)) {
                Object src;
                Object i2222;
                String pFullName = p.getFullName();
                LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Checking {3} for a match", new Object[]{eventClass, eventType, eventTimestamp, pFullName});
                BranchProjectFactory _factory = p.getProjectFactory();
                matches.clear();
                candidateNames.clear();
                revisionMaps.clear();
                for (SCMSource source : p.getSCMSources()) {
                    Map eventHeads;
                    if (!event.isMatch(source) || (eventHeads = event.heads(source)).isEmpty()) continue;
                    revisionMaps.put(source, eventHeads);
                    for (SCMHead h : eventHeads.keySet()) {
                        candidateNames.add(h.getName());
                    }
                }
                jobs.clear();
                block39: for (Object i2222 : p.getItems()) {
                    SCMRevision lastBuild;
                    SCMRevision revision;
                    Branch branch;
                    if (!_factory.isProject((Item)i2222) || !candidateNames.contains((branch = _factory.getBranch(i2222)).getName())) continue;
                    if (branch instanceof Branch.Dead) {
                        LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Resurrect dead branch {4} (job {5})?", new Object[]{eventClass, eventType, eventTimestamp, pFullName, branch.getName(), i2222.getName()});
                        for (SCMSource src2 : p.getSCMSources()) {
                            Map revisionMap = (Map)revisionMaps.get(src2);
                            if (revisionMap == null) continue;
                            SCMHead head = branch.getHead();
                            for (SCMHead h : revisionMap.keySet()) {
                                if (!h.getName().equals(head.getName())) continue;
                                matches.put(src2, head);
                                jobs.add(i2222);
                                continue block39;
                            }
                        }
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Matches existing branch {4} (job {5})?", new Object[]{eventClass, eventType, eventTimestamp, pFullName, branch.getName(), i2222.getName()});
                    src = p.getSCMSource(branch.getSourceId());
                    if (src == null) continue;
                    Map revisionMap = (Map)revisionMaps.get(src);
                    if (revisionMap == null) {
                        LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Event does not match current source of {4} (job {5}), checking for take-over", new Object[]{eventClass, eventType, eventTimestamp, pFullName, branch.getName(), i2222.getName()});
                        int ourPriority = Integer.MAX_VALUE;
                        int oldPriority = Integer.MAX_VALUE;
                        SCMSource ourSource = null;
                        int priority = 1;
                        for (SCMSource s : p.getSCMSources()) {
                            String sId = s.getId();
                            Map rMap = (Map)revisionMaps.get(s);
                            if (ourPriority > priority && oldPriority > priority && rMap != null) {
                                for (SCMHead h : rMap.keySet()) {
                                    if (!branch.getName().equals(h.getName())) continue;
                                    ourPriority = priority;
                                    ourSource = s;
                                    break;
                                }
                            }
                            if (sId.equals(src.getId())) {
                                oldPriority = priority;
                            }
                            ++priority;
                        }
                        if (oldPriority < ourPriority) {
                            LOGGER.log(Level.FINEST, "{0} {1} {2,date} {2,time}: Checking {3} -> Ignoring event for {4} (job {5}) from source #{6} as source #{7} owns the branch name", new Object[]{eventClass, eventType, eventTimestamp, pFullName, branch.getName(), i2222.getName(), ourPriority, oldPriority});
                            continue;
                        }
                        LOGGER.log(Level.FINER, "{0} {1} {2,date} {2,time}: Checking {3} -> Takeover event for {4} (job {5}) by source #{5} from source #{6}", new Object[]{eventClass, eventType, eventTimestamp, pFullName, branch.getName(), i2222.getName(), ourPriority, oldPriority});
                        assert (ourSource != null);
                        src = ourSource;
                        revisionMap = (Map)revisionMaps.get(ourSource);
                        assert (revisionMap != null);
                    }
                    SCMHead head = branch.getHead();
                    boolean match = false;
                    for (SCMHead h : revisionMap.keySet()) {
                        if (!h.getName().equals(head.getName())) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Checking {3} -> Event matches source of {4} (job {5})", new Object[]{eventClass, eventType, eventTimestamp, pFullName, branch.getName(), i2222.getName()});
                    if (SCMEvent.Type.UPDATED == event.getType() && (revision = (SCMRevision)revisionMap.get(head)) != null && revision.isDeterministic() && revision.equals((Object)(lastBuild = _factory.getRevision(i2222)))) {
                        LOGGER.log(Level.FINE, "{0} {1} {2,date} {2,time}: Checking {3} -> Ignoring event as revision {4} is same as last build of {5} (job {6})", new Object[]{eventClass, eventType, eventTimestamp, pFullName, revision, branch.getName(), i2222.getName()});
                        continue;
                    }
                    matches.put(src, head);
                    jobs.add(i2222);
                }
                if (!matches.isEmpty()) {
                    ++matchCount;
                    global.getLogger().format("Found match against %s%n", pFullName);
                    long start = System.currentTimeMillis();
                    try {
                        StreamTaskListener listener = p.getComputation().createEventsListener();
                        src = null;
                        try {
                            long end;
                            try {
                                listener.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", start, eventClass, eventType, eventOrigin, eventTimestamp);
                                ChildObserver childObserver = p.createEventsChildObserver();
                                for (Map.Entry m : matches.entrySet()) {
                                    SCMSource sCMSource = (SCMSource)m.getKey();
                                    SCMSourceCriteria sCMSourceCriteria = p.getSCMSourceCriteria((SCMSource)m.getKey());
                                    MultiBranchProject multiBranchProject = p;
                                    ((Object)((Object)multiBranchProject)).getClass();
                                    sCMSource.fetch(sCMSourceCriteria, (SCMHeadObserver)multiBranchProject.new SCMHeadObserverImpl((SCMSource)m.getKey(), childObserver, (TaskListener)listener, _factory, new EventCauseFactory(event), event), event, (TaskListener)listener);
                                }
                                Set names = childObserver.observed();
                                for (Job j : jobs) {
                                    if (names.contains(j.getName())) continue;
                                    Branch branch = _factory.getBranch(j);
                                    String sourceId = branch.getSourceId();
                                    boolean foundSource = false;
                                    for (SCMSource s : matches.keySet()) {
                                        if (!sourceId.equals(s.getId())) continue;
                                        foundSource = true;
                                    }
                                    if (!foundSource) continue;
                                    _factory.decorate(_factory.setBranch(j, new Branch.Dead(branch)));
                                    j.save();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace(listener.error(e.getMessage()));
                                end = System.currentTimeMillis();
                                listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace(listener.error(e.getMessage()));
                                throw e;
                                {
                                    catch (Throwable throwable) {
                                        long end2 = System.currentTimeMillis();
                                        listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end2, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end2 - start)));
                                        throw throwable;
                                    }
                                }
                            }
                            end = System.currentTimeMillis();
                            listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                            continue;
                        }
                        catch (Throwable e) {
                            src = e;
                            throw e;
                        }
                        finally {
                            if (listener == null) continue;
                            if (src != null) {
                                try {
                                    listener.close();
                                }
                                catch (Throwable e) {
                                    ((Throwable)src).addSuppressed(e);
                                }
                                continue;
                            }
                            listener.close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventClass, eventType, eventOrigin, eventTimestamp}));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventClass, eventType, eventOrigin, eventTimestamp}));
                        throw e;
                    }
                }
                boolean haveMatch = false;
                i2222 = p.getSCMSources().iterator();
                while (i2222.hasNext()) {
                    SCMSource source = (SCMSource)i2222.next();
                    if (!event.isMatch(source)) continue;
                    for (SCMHead h : event.heads(source).keySet()) {
                        if (p.getItemByBranchName(h.getName()) != null) continue;
                        haveMatch = true;
                        break;
                    }
                    if (!haveMatch) break;
                    ++matchCount;
                    global.getLogger().format("Found match against %s%n", pFullName);
                    break;
                }
                if (!haveMatch) continue;
                long start = System.currentTimeMillis();
                try {
                    StreamTaskListener listener = p.getComputation().createEventsListener();
                    Throwable throwable = null;
                    try {
                        long end;
                        listener.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", start, eventClass, eventType, eventOrigin, eventTimestamp);
                        ChildObserver childObserver = p.createEventsChildObserver();
                        try {
                            for (SCMSource source : p.getSCMSources()) {
                                if (!event.isMatch(source)) continue;
                                SCMSourceCriteria sCMSourceCriteria = p.getSCMSourceCriteria(source);
                                MultiBranchProject multiBranchProject = p;
                                ((Object)((Object)multiBranchProject)).getClass();
                                source.fetch(sCMSourceCriteria, (SCMHeadObserver)multiBranchProject.new SCMHeadObserverImpl(source, childObserver, (TaskListener)listener, _factory, new EventCauseFactory(event), event), event, (TaskListener)listener);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error(e.getMessage()));
                            end = System.currentTimeMillis();
                            listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(listener.error(e.getMessage()));
                            throw e;
                            {
                                catch (Throwable throwable2) {
                                    long end3 = System.currentTimeMillis();
                                    listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end3, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end3 - start)));
                                    throw throwable2;
                                }
                            }
                        }
                        end = System.currentTimeMillis();
                        listener.getLogger().format("[%tc] %s %s event from %s with timestamp %tc processed in %s%n", end, eventClass, eventType, eventOrigin, eventTimestamp, Util.getTimeSpanString((long)(end - start)));
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (listener == null) continue;
                        if (throwable != null) {
                            try {
                                listener.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        listener.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventClass, eventType, eventOrigin, eventTimestamp}));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), eventClass, eventType, eventOrigin, eventTimestamp}));
                    throw e;
                }
            }
            return matchCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onSCMSourceEvent(SCMSourceEvent<?> event) {
            block44: {
                try {
                    global = this.globalEventsListener();
                    var3_4 = null;
                    try {
                        global.getLogger().format("[%tc] Received %s %s event from %s with timestamp %tc%n", new Object[]{System.currentTimeMillis(), event.getClass().getName(), event.getType().name(), event.getOrigin(), event.getTimestamp()});
                        matchCount = 0;
                        if (SCMEvent.Type.UPDATED == event.getType()) {
                            try {
                                block33: for (MultiBranchProject p : Jenkins.getActiveInstance().getAllItems(MultiBranchProject.class)) {
                                    haveMatch = false;
                                    scmSources = p.getSCMSources();
                                    for (SCMSource s : scmSources) {
                                        if (!event.isMatch(s)) continue;
                                        ++matchCount;
                                        global.getLogger().format("Found match against %s%n", new Object[]{p.getFullName()});
                                        haveMatch = true;
                                        break;
                                    }
                                    if (!haveMatch) continue;
                                    try {
                                        listener = p.getComputation().createEventsListener();
                                        var10_16 = null;
                                        try {
                                            try {
                                                stateActions = new HashMap<String, List>();
                                                for (SCMSource var13_25 : scmSources) {
                                                    oldActions = (List)State.access$100(MultiBranchProject.access$800(p)).get(var13_25.getId());
                                                    try {
                                                        newActions = var13_25.fetchActions(event, (TaskListener)listener);
                                                    }
                                                    catch (IOException e) {
                                                        e.printStackTrace(listener.error("Could not refresh actions for source %s", new Object[]{var13_25.getId()}));
                                                        newActions = oldActions;
                                                    }
                                                    if (oldActions != null && oldActions.equals(newActions)) continue;
                                                    stateActions.put(var13_25.getId(), newActions);
                                                }
                                                if (stateActions.isEmpty()) continue;
                                                saveProject = false;
                                                var13_26 = stateActions.values().iterator();
                                                while (true) {
                                                    if (var13_26.hasNext()) {
                                                        actions = (List)var13_26.next();
                                                        var15_29 = actions.iterator();
                                                        break block44;
                                                    }
                                                    var13_27 = new BulkChange((Saveable)MultiBranchProject.access$800(p));
                                                    try {
                                                        State.access$100(MultiBranchProject.access$800(p)).putAll(stateActions);
                                                        var13_27.commit();
                                                        if (!saveProject) continue block33;
                                                        p.save();
                                                        continue block33;
                                                    }
                                                    finally {
                                                        var13_27.abort();
                                                        continue block33;
                                                    }
                                                    break;
                                                }
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace(listener.error(e.getMessage()));
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace(listener.error(e.getMessage()));
                                                throw e;
                                            }
                                        }
                                        catch (Throwable var11_21) {
                                            var10_16 = var11_21;
                                            throw var11_21;
                                        }
                                        finally {
                                            if (listener == null) continue;
                                            if (var10_16 != null) {
                                                try {
                                                    listener.close();
                                                }
                                                catch (Throwable var11_20) {
                                                    var10_16.addSuppressed(var11_20);
                                                }
                                                continue;
                                            }
                                            listener.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace(global.error("[%tc] %s encountered an error while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), event.getClass().getName(), event.getType().name(), event.getOrigin(), event.getTimestamp()}));
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace(global.error("[%tc] %s was interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), ModelHyperlinkNote.encodeTo((Item)p), event.getClass().getName(), event.getType().name(), event.getOrigin(), event.getTimestamp()}));
                                        throw e;
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace(global.error("[%tc] Interrupted while processing %s %s event from %s with timestamp %tc", new Object[]{System.currentTimeMillis(), event.getClass().getName(), event.getType().name(), event.getOrigin(), event.getTimestamp()}));
                            }
                        }
                        global.getLogger().format("[%tc] Finished processing %s %s event from %s with timestamp %tc. Matched %d.%n", new Object[]{System.currentTimeMillis(), event.getClass().getName(), event.getType().name(), event.getOrigin(), event.getTimestamp(), matchCount});
                        return;
                    }
                    catch (Throwable var4_7) {
                        var3_4 = var4_7;
                        throw var4_7;
                    }
                    finally {
                        if (global != null) {
                            if (var3_4 != null) {
                                try {
                                    global.close();
                                }
                                catch (Throwable var4_6) {
                                    var3_4.addSuppressed(var4_6);
                                }
                            } else {
                                global.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    MultiBranchProject.access$400().log(Level.WARNING, "Could not close global event log file", e);
                }
                return;
            }
            while (true) {
                if (!var15_29.hasNext()) ** continue;
                a = (Action)var15_29.next();
                saveProject = p.removeActions(a.getClass()) != false || saveProject != false;
            }
        }
    }

    private static class BranchSourceList
    extends PersistedList<BranchSource> {
        BranchSourceList(MultiBranchProject<?, ?> owner) {
            super(owner);
        }

        protected void onModified() throws IOException {
            super.onModified();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BranchSource branchSource = (BranchSource)((Object)iterator.next());
                branchSource.getSource().setOwner((SCMSourceOwner)((MultiBranchProject)this.owner));
            }
        }
    }

    public static class BranchIndexing<P extends Job<P, R>, R extends Run<P, R>>
    extends FolderComputation<P> {
        public BranchIndexing(@NonNull MultiBranchProject<P, R> project, @CheckForNull BranchIndexing<P, R> previousIndexing) {
            super(project, previousIndexing);
        }

        public MultiBranchProject<P, R> getParent() {
            return (MultiBranchProject)super.getParent();
        }

        protected XmlFile getDataFile() {
            return new XmlFile(Items.XSTREAM, new File(this.getParent().getComputationDir(), "indexing.xml"));
        }

        public File getLogFile() {
            return new File(this.getParent().getComputationDir(), "indexing.log");
        }

        public String getDisplayName() {
            return Messages.MultiBranchProject_BranchIndexing_displayName(this.getParent().getPronoun());
        }

        public String getUrl() {
            return this.getParent().getUrl() + "indexing/";
        }

        public String getSearchUrl() {
            return "indexing/";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            try {
                super.run();
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                LOGGER.log(Level.INFO, "{0} #{1,time,yyyyMMdd.HHmmss} branch indexing action completed: {2} in {3}", new Object[]{this.getParent().getFullName(), start, this.getResult(), Util.getTimeSpanString((long)(end - start))});
                throw throwable;
            }
            long end = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "{0} #{1,time,yyyyMMdd.HHmmss} branch indexing action completed: {2} in {3}", new Object[]{this.getParent().getFullName(), start, this.getResult(), Util.getTimeSpanString((long)(end - start))});
        }
    }
}

