/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.Extension;
import hudson.model.Actionable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchStatusColumn;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectViewHolder;
import jenkins.branch.OrganizationFolderViewHolder;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class ItemColumn
extends ListViewColumn {
    @DataBoundConstructor
    public ItemColumn() {
    }

    public boolean isPrimary(Object job) {
        return job instanceof Actionable && ((Actionable)job).getAction(PrimaryInstanceMetadataAction.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOrphaned(Object item) {
        Job job;
        ItemGroup parent;
        if (item instanceof Job && (parent = (job = (Job)item).getParent()) instanceof MultiBranchProject) {
            BranchProjectFactory factory = ((MultiBranchProject)parent).getProjectFactory();
            return factory.isProject((Item)job) && factory.getBranch(job) instanceof Branch.Dead;
        }
        if (item instanceof MultiBranchProject) {
            MultiBranchProject project = (MultiBranchProject)((Object)item);
            BranchProjectFactory factory = project.getProjectFactory();
            SecurityContext ctx = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                for (Job c : project.getItems()) {
                    if (!factory.isProject((Item)c) || factory.getBranch(c) instanceof Branch.Dead) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)ctx);
            }
        }
        return false;
    }

    public String getTitle(Object job) {
        Actionable actionable;
        ObjectMetadataAction action;
        if (job instanceof Actionable && (action = (ObjectMetadataAction)(actionable = (Actionable)job).getAction(ObjectMetadataAction.class)) != null) {
            String dispayName = action.getObjectDisplayName();
            if (StringUtils.isBlank((String)dispayName) || dispayName.equals(actionable.getDisplayName())) {
                String description = action.getObjectDescription();
                return description != null ? description : dispayName;
            }
            return dispayName;
        }
        return null;
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            return !(descriptor instanceof BranchStatusColumn.DescriptorImpl) || context instanceof MultiBranchProjectViewHolder.ViewImpl || context instanceof OrganizationFolderViewHolder.ViewImpl;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.ItemColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

